/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.environment.core.map;

import cn.jdevelops.environment.entity.MapPoint;
import java.math.BigDecimal;

public class MapFix {
    private double casmF = 0.0;
    private double casmRr = 0.0;
    private double casmT1 = 0.0;
    private double casmT2 = 0.0;
    private double casmX1 = 0.0;
    private double casmX2 = 0.0;
    private double casmY1 = 0.0;
    private double casmY2 = 0.0;
    private static volatile MapFix instance;

    private MapFix() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MapFix getInstance() {
        if (instance != null) return instance;
        Class<MapFix> clazz = MapFix.class;
        synchronized (MapFix.class) {
            if (instance != null) return instance;
            instance = new MapFix();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public double[] fix(double x, double y) {
        double[] res = new double[2];
        try {
            double num = x * 3686400.0;
            double num2 = y * 3686400.0;
            MapPoint point = this.wgtochinaLb((int)num, (int)num2);
            assert (point != null);
            double num6 = point.getX();
            double num7 = point.getY();
            res[0] = num6 /= 3686400.0;
            res[1] = num7 /= 3686400.0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }

    private void iniCasm(double wTime, double wLng, double wLat) {
        this.casmT1 = wTime;
        this.casmT2 = wTime;
        double num = (int)(wTime / 0.357);
        this.casmRr = wTime - num * 0.357;
        if (this.doubleEq(0.0, wTime)) {
            this.casmRr = 0.3;
        }
        this.casmX1 = wLng;
        this.casmY1 = wLat;
        this.casmX2 = wLng;
        this.casmY2 = wLat;
        this.casmF = 3.0;
    }

    private double randomYj() {
        double num = 3.14159269E8;
        double num2 = 4.53806245E8;
        this.casmRr = num * this.casmRr + num2;
        double num3 = (int)(this.casmRr / 2.0);
        this.casmRr -= num3 * 2.0;
        this.casmRr /= 2.0;
        return this.casmRr;
    }

    private double transformJy5(double x, double xx) {
        double num = 6378245.0;
        double num2 = 0.00669342;
        double num3 = Math.sqrt(1.0 - num2 * this.yjSin2(x * 0.0174532925199433) * this.yjSin2(x * 0.0174532925199433));
        return xx * 180.0 / (num / num3 * Math.cos(x * 0.0174532925199433) * 3.1415926);
    }

    private double transformJyj5(double x, double yy) {
        double num = 6378245.0;
        double num2 = 0.00669342;
        double d = 1.0 - num2 * this.yjSin2(x * 0.0174532925199433) * this.yjSin2(x * 0.0174532925199433);
        double num4 = num * (1.0 - num2) / (d * Math.sqrt(d));
        return yy * 180.0 / (num4 * 3.1415926);
    }

    private double transformYj5(double x, double y) {
        double num = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.sqrt(x * x));
        num += (20.0 * this.yjSin2(18.849555921538762 * x) + 20.0 * this.yjSin2(6.283185307179588 * x)) * 0.6667;
        return (num += (20.0 * this.yjSin2(3.141592653589794 * x) + 40.0 * this.yjSin2(1.047197551196598 * x)) * 0.6667) + (150.0 * this.yjSin2(0.2617993877991495 * x) + 300.0 * this.yjSin2(0.1047197551196598 * x)) * 0.6667;
    }

    private double transformYjy5(double x, double y) {
        double num = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.sqrt(x * x));
        num += (20.0 * this.yjSin2(18.849555921538762 * x) + 20.0 * this.yjSin2(6.283185307179588 * x)) * 0.6667;
        return (num += (20.0 * this.yjSin2(3.141592653589794 * y) + 40.0 * this.yjSin2(1.047197551196598 * y)) * 0.6667) + (160.0 * this.yjSin2(0.2617993877991495 * y) + 320.0 * this.yjSin2(0.1047197551196598 * y)) * 0.6667;
    }

    private MapPoint wgtochinaLb(int wgLng, int wgLat) {
        MapPoint point = new MapPoint();
        double num = wgLng;
        num /= 3686400.0;
        double x = wgLat;
        x /= 3686400.0;
        if (num < 72.004) {
            return null;
        }
        if (num > 137.8347) {
            return null;
        }
        if (x < 0.8293) {
            return null;
        }
        if (x > 55.8271) {
            return null;
        }
        this.casmT2 = 0.0;
        double num3 = (this.casmT2 - this.casmT1) / 1000.0;
        if (num3 <= 0.0) {
            this.casmT1 = this.casmT2;
            this.casmF += 1.0;
            this.casmX1 = this.casmX2;
            this.casmF += 1.0;
            this.casmY1 = this.casmY2;
            this.casmF += 1.0;
        } else if (num3 > 120.0) {
            if (this.doubleEq(3.0, this.casmF)) {
                this.casmF = 0.0;
                this.casmX2 = wgLng;
                this.casmY2 = wgLat;
                double num4 = this.casmX2 - this.casmX1;
                double num5 = this.casmY2 - this.casmY1;
                double num6 = Math.sqrt(num4 * num4 + num5 * num5) / num3;
                if (num6 > 3185.0) {
                    return point;
                }
            }
            this.casmT1 = this.casmT2;
            this.casmF += 1.0;
            this.casmX1 = this.casmX2;
            this.casmF += 1.0;
            this.casmY1 = this.casmY2;
            this.casmF += 1.0;
        }
        double xx = this.transformYj5(num - 105.0, x - 35.0);
        double yy = this.transformYjy5(num - 105.0, x - 35.0);
        xx = xx + 0.0 + this.yjSin2(0.0) + this.randomYj();
        yy = yy + 0.0 + this.yjSin2(0.0) + this.randomYj();
        point = new MapPoint();
        point.setX((num + this.transformJy5(x, xx)) * 3686400.0);
        point.setY((x + this.transformJyj5(x, yy)) * 3686400.0);
        return point;
    }

    private double yjSin2(double x) {
        int num2;
        double num3;
        double num = 0.0;
        if (x < 0.0) {
            x = -x;
            num = 1.0;
        }
        if ((num3 = x - (double)(num2 = (int)(x / 6.28318530717959)) * 6.28318530717959) > Math.PI) {
            num3 -= Math.PI;
            num = this.doubleEq(1.0, num) ? 0.0 : 1.0;
        }
        double num4 = x = num3;
        double num5 = x;
        num3 *= num3;
        num4 -= (num5 *= num3) * 0.166666666666667;
        num4 += (num5 *= num3) * 0.00833333333333333;
        num4 -= (num5 *= num3) * 1.98412698412698E-4;
        num4 += (num5 *= num3) * 2.75573192239859E-6;
        num4 -= (num5 *= num3) * 2.50521083854417E-8;
        if (this.doubleEq(1.0, num)) {
            num4 = -num4;
        }
        return num4;
    }

    private boolean doubleEq(double a, double b) {
        return BigDecimal.valueOf(a).compareTo(BigDecimal.valueOf(b)) == 0;
    }
}

