/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.environment.core.wind;

import java.util.HashMap;
import java.util.Map;

public class WeatherSwitchUtil {
    private static Map<String, String> windPowerMap = WeatherSwitchUtil.getWindInfo();
    private static Map<String, String> windDirectMap = WeatherSwitchUtil.getWindDirect();

    public static String getWindDirection(double windAvg2Mi) {
        String windDirection = 0.0 == windAvg2Mi || 360.0 == windAvg2Mi ? "\u5317" : (windAvg2Mi == 90.0 ? "\u4e1c" : (windAvg2Mi == 180.0 ? "\u5357" : (windAvg2Mi == 270.0 ? "\u897f" : (windAvg2Mi > 0.0 && windAvg2Mi < 90.0 ? "\u4e1c\u5317" : (windAvg2Mi > 90.0 && windAvg2Mi < 180.0 ? "\u4e1c\u5357" : (windAvg2Mi > 180.0 && windAvg2Mi < 270.0 ? "\u897f\u5357" : "\u897f\u5317"))))));
        return windDirection;
    }

    public static String getWindPower(double windVelocity) {
        for (Map.Entry<String, String> map : windPowerMap.entrySet()) {
            double windMin;
            String windRegion = map.getValue();
            String windName = map.getKey();
            if (windRegion.contains("-")) {
                String[] windRegionArray = windRegion.split("-");
                double windMin2 = Double.parseDouble(windRegionArray[0]);
                double windMax = Double.parseDouble(windRegionArray[1]);
                if (windVelocity >= windMin2 && windVelocity <= windMax + 0.1) {
                    return windName;
                }
            }
            if (!windRegion.contains(">") || !(windVelocity >= (windMin = Double.parseDouble(windRegion.split(">")[0])))) continue;
            return windName;
        }
        return "\u65e0\u98ce";
    }

    public static String getWindVelocity(double windVelocity) {
        for (Map.Entry<String, String> map : windDirectMap.entrySet()) {
            String windRegion = map.getValue();
            String windName = map.getKey();
            if (!windRegion.contains("-")) continue;
            String[] windRegionArray = windRegion.split("-");
            double windMin = Double.parseDouble(windRegionArray[0]);
            double windMax = Double.parseDouble(windRegionArray[1]);
            if (windVelocity >= windMin && windVelocity <= windMax + 0.01) {
                return windName;
            }
            if (!(windVelocity >= 348.76) && !(windVelocity <= 11.25)) continue;
            return windName;
        }
        return "\u65e0\u98ce";
    }

    private static Map<String, String> getWindInfo() {
        HashMap<String, String> windPowerMap = new HashMap<String, String>(16);
        windPowerMap.put("\u65e0\u98ce", "0.0-0.2");
        windPowerMap.put("\u8f6f\u98ce", "0.3-1.5");
        windPowerMap.put("\u8f7b\u98ce", "1.6-3.3");
        windPowerMap.put("\u5fae\u98ce", "3.4-5.4");
        windPowerMap.put("\u548c\u98ce", "5.5-7.9");
        windPowerMap.put("\u6e05\u98ce", "8.0-10.7");
        windPowerMap.put("\u5f3a\u98ce", "10.8-13.8");
        windPowerMap.put("\u52b2\u98ce", "13.9-17.1");
        windPowerMap.put("\u5927\u98ce", "17.2-20.7");
        windPowerMap.put("\u70c8\u98ce", "20.8-24.4");
        windPowerMap.put("\u72c2\u98ce", "24.5-28.4");
        windPowerMap.put("\u66b4\u98ce", "28.5-32.6");
        windPowerMap.put("\u53f0\u98ce", ">32.6");
        return windPowerMap;
    }

    private static Map<String, String> getWindDirect() {
        HashMap<String, String> windDirectMap = new HashMap<String, String>(16);
        windDirectMap.put("\u5317", "348.76-11.25");
        windDirectMap.put("\u5317\u4e1c\u5317", "11.26-33.75");
        windDirectMap.put("\u4e1c\u5317", "33.76-56.25");
        windDirectMap.put("\u4e1c\u4e1c\u5317", "56.26-78.75");
        windDirectMap.put("\u4e1c", "78.76-101.25");
        windDirectMap.put("\u4e1c\u4e1c\u5357", "101.26-123.75");
        windDirectMap.put("\u4e1c\u5357", "123.76-146.25");
        windDirectMap.put("\u5357\u4e1c\u5357", "146.26-168.75");
        windDirectMap.put("\u5357", "168.76-191.25");
        windDirectMap.put("\u5357\u897f\u5357", "191.26-213.75");
        windDirectMap.put("\u897f\u5357", "213.76-236.25");
        windDirectMap.put("\u897f\u897f\u5357", "236.26-258.75");
        windDirectMap.put("\u897f", "258.76-281.25");
        windDirectMap.put("\u897f\u897f\u5317", "281.26-303.75");
        windDirectMap.put("\u897f\u5317", "303.76-326.25");
        windDirectMap.put("\u5317\u897f\u5317", "326.26-348.75");
        return windDirectMap;
    }
}

