/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.encryption.core;

import cn.jdevelops.encryption.util.RemarkUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignShaUtil {
    private static final Logger log = LoggerFactory.getLogger(SignShaUtil.class);

    public static String encrypt(String str) {
        if (null == str || 0 == str.length()) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("SHA1");
            mdTemp.update(new String(str.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8).getBytes());
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                buf[k++] = hexDigits[byte0 >>> 4 & 0xF];
                buf[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(buf);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            log.error("SHA1\u52a0\u5bc6\u5f02\u5e38:", (Throwable)e);
            return str;
        }
    }

    public static String encrypt(Object obj) {
        if (obj == null) {
            return null;
        }
        Map<String, Object> map = obj instanceof Map ? (Map<String, Object>)obj : RemarkUtil.transBean2Map(obj);
        map.remove("sign");
        map.remove("encrypt");
        String result = RemarkUtil.map2Str(map);
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        return SignShaUtil.encrypt(result);
    }

    public static boolean check(Object obj) {
        if (obj == null) {
            return false;
        }
        Map<String, Object> map = obj instanceof Map ? (Map<String, Object>)obj : RemarkUtil.transBean2Map(obj);
        String sign = (String)map.get("sign");
        if (sign == null) {
            return false;
        }
        String str = SignShaUtil.encrypt(obj);
        return sign.equals(str);
    }
}

