/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.encryption.core;

import cn.jdevelops.encryption.util.RemarkUtil;
import cn.jdevelops.enums.number.NumEnum;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignMD5Util {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SignMD5Util.class);

    public static String encrypt(String plainText) {
        return SignMD5Util.encrypt(plainText, true);
    }

    public static String encrypt(String plainText, boolean flag) throws RuntimeException {
        byte[] secretBytes;
        if (StringUtils.isEmpty((CharSequence)plainText)) {
            return null;
        }
        try {
            secretBytes = MessageDigest.getInstance("md5").digest(plainText.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6ca1\u6709md5\u8fd9\u4e2a\u7b97\u6cd5\uff01", e);
        }
        StringBuilder md5code = new StringBuilder(new BigInteger(1, secretBytes).toString(16));
        for (int i = 0; i < NumEnum.THIRTY_TWO.getNum() - md5code.length(); ++i) {
            md5code.insert(0, "0");
        }
        if (flag) {
            return md5code.toString();
        }
        return md5code.substring(8, 24);
    }

    public static String encrypt(Object obj, String salt) {
        if (obj != null) {
            Map<String, Object> map = obj instanceof Map ? (Map<String, Object>)obj : RemarkUtil.transBean2Map(obj);
            return SignMD5Util.encrypt(map, salt, true);
        }
        return null;
    }

    public static String encrypt(Map<String, Object> map, String salt, boolean flag) {
        map.remove("sign");
        map.remove("encrypt");
        String result = RemarkUtil.map2Str(map);
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        String param = SignMD5Util.encrypt(SignMD5Util.encrypt(result) + salt);
        if (flag) {
            return param;
        }
        param = param.substring(8, 24);
        return param;
    }

    public static String encryptHeader(String result, String salt, boolean flag) {
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        String param = SignMD5Util.encrypt(SignMD5Util.encrypt(result) + salt);
        if (flag) {
            return param;
        }
        param = param.substring(8, 24);
        return param;
    }

    public static boolean check(Object obj, String salt) {
        try {
            if (obj == null) {
                return false;
            }
            Map<String, Object> map = obj instanceof Map ? (Map<String, Object>)obj : RemarkUtil.transBean2Map(obj);
            String sign = (String)map.get("sign");
            if (StringUtils.isEmpty((CharSequence)sign)) {
                return false;
            }
            String str = SignMD5Util.encrypt(map, salt);
            return sign.equals(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u53c2\u6570\u6709\u8bef", e);
        }
    }

    public static boolean checkHeader(HttpServletRequest request, String jsonString, String salt) {
        try {
            String sign = SignMD5Util.getHeaderSign(request);
            if (StringUtils.isEmpty((CharSequence)sign)) {
                return false;
            }
            String str = SignMD5Util.encryptHeader(jsonString, salt, true);
            return sign.equals(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u53c2\u6570\u6709\u8bef", e);
        }
    }

    public static String getHeaderSign(HttpServletRequest request) {
        String signName = "sign";
        String sign = request.getHeader("sign");
        if (StringUtils.isNotBlank((CharSequence)sign)) {
            return sign;
        }
        sign = request.getParameter("sign");
        return sign;
    }
}

