/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.sms.mail.service.impl;

import cn.jdevelops.sms.mail.service.MailService;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class MailServiceImpl
implements MailService {
    private final JavaMailSender mailSender;
    private final MailProperties mailProperties;

    public MailServiceImpl(JavaMailSender mailSender, MailProperties mailProperties) {
        this.mailSender = mailSender;
        this.mailProperties = mailProperties;
    }

    @Override
    public void sendSimpleMail(String to, String subject, String content, String ... cc) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(this.mailProperties.getUsername());
        message.setTo(to);
        message.setSubject(subject);
        message.setText(content);
        if (!ObjectUtils.isEmpty((Object[])cc)) {
            message.setCc(cc);
        }
        this.mailSender.send(message);
    }

    @Override
    public void sendHtmlMail(String to, String subject, String content, String ... cc) throws MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        this.buildHelper(to, subject, content, message, cc);
        this.mailSender.send(message);
    }

    @Override
    public void sendAttachmentsMail(String to, String subject, String content, String filePath, String ... cc) throws MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = this.buildHelper(to, subject, content, message, cc);
        FileSystemResource file = new FileSystemResource(new File(filePath));
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator));
        helper.addAttachment(fileName, (InputStreamSource)file);
        this.mailSender.send(message);
    }

    @Override
    public void sendAttachmentsMail(String to, String subject, String content, List<String> filePath, String ... cc) throws MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = this.buildHelper(to, subject, content, message, cc);
        for (String s : filePath) {
            FileSystemResource file = new FileSystemResource(new File(s));
            String fileName = s.substring(s.lastIndexOf(File.separator) + 1);
            helper.addAttachment(fileName, (InputStreamSource)file);
        }
        this.mailSender.send(message);
    }

    @Override
    public void sendResourceMail(String to, String subject, String content, String rscPath, String rscId, String ... cc) throws MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = this.buildHelper(to, subject, content, message, cc);
        FileSystemResource res = new FileSystemResource(new File(rscPath));
        helper.addInline(rscId, (Resource)res);
        this.mailSender.send(message);
    }

    @Override
    public void sendUrlResourceMail(String to, String subject, String content, List<String> urls, String ... cc) throws MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = this.buildHelper(to, subject, content, message, cc);
        MimeMultipart mimeMultipart = helper.getMimeMultipart();
        for (String url : urls) {
            try {
                new URLDataSource(new URL(url));
                MimeBodyPart bodyPart = new MimeBodyPart();
                DataHandler dh = new DataHandler((DataSource)new URLDataSource(new URL(url)));
                bodyPart.setDataHandler(dh);
                bodyPart.setFileName(url.substring(urls.lastIndexOf("/") + 1));
                mimeMultipart.addBodyPart((BodyPart)bodyPart);
                this.mailSender.send(message);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private MimeMessageHelper buildHelper(String to, String subject, String content, MimeMessage message, String ... cc) throws MessagingException {
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setFrom(this.mailProperties.getUsername());
        helper.setTo(to);
        helper.setSubject(subject);
        helper.setText(content, true);
        if (!ObjectUtils.isEmpty((Object[])cc)) {
            helper.setCc(cc);
        }
        return helper;
    }
}

