/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.search.es.service.impl;

import cn.jdevelops.search.es.dto.ConditionDTO;
import cn.jdevelops.search.es.dto.EqDTO;
import cn.jdevelops.search.es.dto.SortDTO;
import cn.jdevelops.search.es.dto.SpecialDTO;
import cn.jdevelops.search.es.service.EsSearchService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsSearchServiceImpl
implements EsSearchService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EsSearchServiceImpl.class);
    private RestHighLevelClient restHighLevelClient;

    public EsSearchServiceImpl(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    @Override
    public Map<String, Object> searchDataById(String index, String esOnlyId, String fields) throws IOException {
        GetRequest request = new GetRequest(index, esOnlyId);
        if (StringUtils.isNotEmpty((CharSequence)fields)) {
            request.fetchSourceContext(new FetchSourceContext(true, fields.split(","), Strings.EMPTY_ARRAY));
        }
        GetResponse response = this.restHighLevelClient.get(request, RequestOptions.DEFAULT);
        return response.getSource();
    }

    @Override
    public SearchResponse getSearch(List<String> index, Integer startPage, Integer pageSize) throws IOException {
        SearchRequest request = new SearchRequest(index.toArray(new String[0]));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        this.setPage(sourceBuilder, startPage, pageSize);
        request.source(sourceBuilder);
        return this.executePage(request);
    }

    @Override
    public SearchResponse getSearch(List<String> index, List<EqDTO> eqDTOList, List<String> terms, List<String> fields, String nested, List<String> nestedFields, List<SpecialDTO> specialDTOList, List<ConditionDTO> conditionDTOList, List<List<List<ConditionDTO>>> listList, String highlightField, Integer startPage, Integer pageSize, List<SortDTO> sortDTOList) throws IOException {
        SearchRequest request = new SearchRequest(index.toArray(new String[0]));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        this.setEqCondition(boolQueryBuilder, eqDTOList);
        if (terms != null && !terms.isEmpty()) {
            boolQueryBuilder.must((QueryBuilder)this.setConditionByTerm(terms, fields, nested, nestedFields));
        }
        if (specialDTOList != null && !specialDTOList.isEmpty()) {
            this.setSpecialDTOList(boolQueryBuilder, specialDTOList);
        }
        boolQueryBuilder.must((QueryBuilder)this.setAdvanced(conditionDTOList));
        this.setAdvancedList(boolQueryBuilder, listList);
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        this.setPage(sourceBuilder, startPage, pageSize);
        this.setOrderField(sourceBuilder, sortDTOList);
        this.setHighlightField(sourceBuilder, highlightField);
        request.source(sourceBuilder);
        return this.executePage(request);
    }

    @Override
    public SearchResponse getSearchFile(List<String> index, List<EqDTO> eqDTOList, List<String> terms, List<String> fields, Integer startPage, Integer pageSize, List<SortDTO> sortDTOList) throws IOException {
        SearchRequest request = new SearchRequest(index.toArray(new String[0]));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        this.setEqCondition(boolQueryBuilder, eqDTOList);
        if (terms != null && !terms.isEmpty()) {
            boolQueryBuilder.must((QueryBuilder)this.setConditionByTerm(terms, fields, null, null));
        }
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        this.setPage(sourceBuilder, startPage, pageSize);
        this.setOrderField(sourceBuilder, sortDTOList);
        request.source(sourceBuilder);
        return this.executePage(request);
    }

    @Override
    public List<Map<String, Object>> getGroup(List<String> index, List<EqDTO> eqDTOList, List<String> terms, List<String> fields, String nested, List<String> nestedFields, List<List<List<ConditionDTO>>> listList, String groupField) throws IOException {
        SearchRequest searchRequest = new SearchRequest(index.toArray(new String[0]));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        this.getBoolQueryBuilder(boolQueryBuilder, eqDTOList, terms, fields, nested, nestedFields, listList);
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        TermsAggregationBuilder field = (TermsAggregationBuilder)AggregationBuilders.terms((String)"sum").field(groupField.trim());
        sourceBuilder.aggregation((AggregationBuilder)field);
        searchRequest.source(sourceBuilder);
        return this.executeGroup(searchRequest);
    }

    private void getBoolQueryBuilder(BoolQueryBuilder boolQueryBuilder, List<EqDTO> eqDTOList, List<String> terms, List<String> fields, String nested, List<String> nestedFields, List<List<List<ConditionDTO>>> listList) {
        this.setEqCondition(boolQueryBuilder, eqDTOList);
        if (terms != null && !terms.isEmpty()) {
            boolQueryBuilder.must((QueryBuilder)this.setConditionByTerm(terms, fields, nested, nestedFields));
        }
        this.setAdvancedList(boolQueryBuilder, listList);
    }

    @Override
    public List<Map<String, Object>> executeGroup(SearchRequest searchRequest) throws IOException {
        SearchResponse search = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        Terms terms1 = (Terms)search.getAggregations().get("sum");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < terms1.getBuckets().size(); ++i) {
            HashMap<String, Long> map = new HashMap<String, Long>(2);
            String key = ((Terms.Bucket)terms1.getBuckets().get(i)).getKey().toString();
            Long sum = ((Terms.Bucket)terms1.getBuckets().get(i)).getDocCount();
            map.put(key, sum);
            list.add(map);
            log.info("\u5206\u7ec4\u540d\u79f0=======:{},\u6570\u636e\u6761\u6570=========:{}", (Object)key, (Object)sum);
        }
        return list;
    }

    @Override
    public SearchResponse executePage(SearchRequest request) throws IOException {
        SearchResponse response = this.restHighLevelClient.search(request, RequestOptions.DEFAULT);
        long totalHits = response.getHits().getTotalHits().value;
        long length = response.getHits().getHits().length;
        log.debug("\u5171\u67e5\u8be2\u5230[{}]\u6761\u6570\u636e,\u5904\u7406\u6570\u636e\u6761\u6570[{}]", (Object)totalHits, (Object)length);
        int status = 200;
        if (response.status().getStatus() == status) {
            return response;
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getAll(SearchRequest searchRequest) throws IOException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        searchRequest.scroll(TimeValue.timeValueMinutes((long)5L));
        SearchResponse response = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        for (SearchHit hit : response.getHits().getHits()) {
            Map sourceAsMap = hit.getSourceAsMap();
            list.add(sourceAsMap);
        }
        String scrollId = response.getScrollId();
        block1: while (true) {
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
            scrollRequest.scroll(TimeValue.timeValueMinutes((long)2L));
            SearchResponse scrollResp = this.restHighLevelClient.scroll(scrollRequest, RequestOptions.DEFAULT);
            scrollId = scrollResp.getScrollId();
            SearchHit[] hits = scrollResp.getHits().getHits();
            if (hits == null || hits.length <= 0) break;
            SearchHit[] searchHitArray = hits;
            int n = searchHitArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block1;
                SearchHit hit = searchHitArray[n2];
                Map sourceAsMap = hit.getSourceAsMap();
                list.add(sourceAsMap);
                ++n2;
            }
            break;
        }
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        ClearScrollResponse clearScrollResponse = this.restHighLevelClient.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
        clearScrollResponse.isSucceeded();
        return list;
    }

    @Override
    public BoolQueryBuilder setEqCondition(BoolQueryBuilder boolQueryBuilder, List<EqDTO> eqDTOList) {
        if (eqDTOList == null || eqDTOList.isEmpty()) {
            return boolQueryBuilder;
        }
        eqDTOList.forEach(i -> {
            if (i.getField() != null && i.getFieldValue() != null && !i.getFieldValue().isEmpty()) {
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)i.getField(), i.getFieldValue()));
            }
        });
        return boolQueryBuilder;
    }

    @Override
    public void setAdvancedList(BoolQueryBuilder boolQueryBuilder, List<List<List<ConditionDTO>>> listList) {
        if (listList == null || listList.isEmpty()) {
            return;
        }
        listList.forEach(i -> {
            if (i != null && !i.isEmpty()) {
                BoolQueryBuilder bq2 = QueryBuilders.boolQuery();
                i.forEach(f -> {
                    if (f != null && !f.isEmpty()) {
                        bq2.should((QueryBuilder)this.setAdvanced((List<ConditionDTO>)f));
                    }
                });
                boolQueryBuilder.must((QueryBuilder)bq2);
            }
        });
    }

    @Override
    public BoolQueryBuilder setAdvanced(List<ConditionDTO> conditionDTOList) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (conditionDTOList != null && !conditionDTOList.isEmpty()) {
            for (ConditionDTO cond : conditionDTOList) {
                if (StringUtils.isBlank((CharSequence)cond.getFieldValue())) continue;
                if (StringUtils.equals((CharSequence)"AND", (CharSequence)cond.getConnectSymbol())) {
                    boolQueryBuilder.must((QueryBuilder)this.setConSymbol(cond.getField(), cond.getFieldValue(), cond.getSymbol()));
                    continue;
                }
                boolQueryBuilder.should((QueryBuilder)this.setConSymbol(cond.getField(), cond.getFieldValue(), cond.getSymbol()));
            }
        }
        return boolQueryBuilder;
    }

    @Override
    public void setSpecialDTOList(BoolQueryBuilder bq, List<SpecialDTO> specialDTOList) {
        if (specialDTOList != null && !specialDTOList.isEmpty()) {
            specialDTOList.forEach(i -> bq.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)i.getField(), (Object)i.getFieldValue())));
        }
    }

    @Override
    public BoolQueryBuilder setConditionByTerm(List<String> terms, List<String> fields, String nested, List<String> nestedFields) {
        BoolQueryBuilder bq = QueryBuilders.boolQuery();
        if (terms != null && !terms.isEmpty()) {
            if (fields != null && !fields.isEmpty()) {
                bq.should((QueryBuilder)this.setFieldsTerm(terms, fields));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nested}) && nestedFields != null && !nestedFields.isEmpty()) {
                bq.should((QueryBuilder)QueryBuilders.nestedQuery((String)nested, (QueryBuilder)this.setNestedFieldsTerm(nested, terms, nestedFields), (ScoreMode)ScoreMode.None));
            }
        }
        return bq;
    }

    @Override
    public BoolQueryBuilder setFieldsTerm(List<String> terms, List<String> fields) {
        BoolQueryBuilder bq2 = QueryBuilders.boolQuery();
        for (String str : terms) {
            if (!StringUtils.isNotBlank((CharSequence)str)) continue;
            BoolQueryBuilder bq22 = QueryBuilders.boolQuery();
            for (String field : fields) {
                if (StringUtils.isBlank((CharSequence)field)) continue;
                bq22.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)field, (Object)str));
            }
            bq2.must((QueryBuilder)bq22);
        }
        return bq2;
    }

    @Override
    public BoolQueryBuilder setNestedFieldsTerm(String nested, List<String> terms, List<String> nestedFields) {
        BoolQueryBuilder bq3 = QueryBuilders.boolQuery();
        for (String str : terms) {
            if (!StringUtils.isNotBlank((CharSequence)str)) continue;
            BoolQueryBuilder bq33 = QueryBuilders.boolQuery();
            for (String field : nestedFields) {
                if (StringUtils.isBlank((CharSequence)field)) continue;
                bq33.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)(nested.trim() + "." + field), (Object)str));
            }
            bq3.must((QueryBuilder)bq33);
        }
        return bq3;
    }

    @Override
    public BoolQueryBuilder setConSymbol(String field, String fieldValue, String symbol) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        switch (symbol.trim()) {
            case "EQ": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)(field + ".keyword"), (String)fieldValue));
                break;
            }
            case "NE": {
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)(field + ".keyword"), (String)fieldValue));
                break;
            }
            case "GT": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)field).gt((Object)fieldValue));
                break;
            }
            case "LT": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)field).lt((Object)fieldValue));
                break;
            }
            case "GE": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)field).gte((Object)fieldValue));
                break;
            }
            case "LE": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)field).lte((Object)fieldValue));
                break;
            }
            case "LIKE": {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)field, (Object)fieldValue));
                break;
            }
        }
        return boolQueryBuilder;
    }

    @Override
    public void setAppointFields(SearchSourceBuilder sourceBuilder, String fields) {
        if (StringUtils.isNotBlank((CharSequence)fields)) {
            sourceBuilder.fetchSource(new FetchSourceContext(true, fields.split(","), Strings.EMPTY_ARRAY));
        }
    }

    @Override
    public void setPage(SearchSourceBuilder sourceBuilder, Integer startPage, Integer pageSize) {
        if (startPage > 0) {
            startPage = startPage - 1;
        }
        int startIndex = startPage * pageSize;
        sourceBuilder.from(startIndex);
        sourceBuilder.size(pageSize.intValue());
        sourceBuilder.trackTotalHits(true);
    }

    @Override
    public void setOrderField(SearchSourceBuilder sourceBuilder, List<SortDTO> list) {
        list.forEach(i -> {
            if (StringUtils.isNotBlank((CharSequence)i.getOrderBy())) {
                if (i.getOrderDesc() == 0) {
                    sourceBuilder.sort(i.getOrderBy(), SortOrder.DESC);
                } else {
                    sourceBuilder.sort(i.getOrderBy(), SortOrder.ASC);
                }
            }
        });
    }

    @Override
    public void setHighlightField(SearchSourceBuilder query, String highlightField) {
        if (StringUtils.isNotBlank((CharSequence)highlightField)) {
            HighlightBuilder highlight = new HighlightBuilder();
            highlight.field(highlightField);
            highlight.requireFieldMatch(Boolean.valueOf(false));
            highlight.preTags(new String[]{"<span style='color:red'>"});
            highlight.postTags(new String[]{"</span>"});
            query.highlighter(highlight);
        }
    }

    @Override
    public List<Map<String, Object>> handleSearchResponse(SearchResponse searchResponse, String highlightField) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (StringUtils.isNotBlank((CharSequence)highlightField)) {
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                Map high = hit.getHighlightFields();
                HighlightField title = (HighlightField)high.get(highlightField);
                Map sourceAsMap = hit.getSourceAsMap();
                if (title != null) {
                    Text[] texts = title.fragments();
                    StringBuilder nTitle = new StringBuilder();
                    for (Text text : texts) {
                        nTitle.append(text);
                    }
                    sourceAsMap.put(highlightField, nTitle.toString());
                }
                list.add(sourceAsMap);
            }
        } else {
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                Map sourceAsMap = hit.getSourceAsMap();
                list.add(sourceAsMap);
            }
        }
        return list;
    }
}

