/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.search.es.service.impl;

import cn.jdevelops.search.es.service.EsIndexService;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsIndexServiceImpl
implements EsIndexService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EsIndexServiceImpl.class);
    private final RestHighLevelClient restHighLevelClient;

    public EsIndexServiceImpl(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    @Override
    public boolean createIndex(String index) throws IOException {
        if (this.isIndexExist(index)) {
            log.error("Index is  exits!");
            return false;
        }
        CreateIndexRequest request = new CreateIndexRequest(index);
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("analysis");
        builder.startObject("analyzer").startObject("ngram_analyzer").field("tokenizer", "ngram_tokenizer").endObject().endObject();
        builder.startObject("tokenizer").startObject("ngram_tokenizer").field("type", "ngram").array("token_chars", new String[]{"letter", "digit"}).endObject().endObject();
        builder.endObject().endObject();
        request.settings(builder);
        CreateIndexResponse response = this.restHighLevelClient.indices().create(request, RequestOptions.DEFAULT);
        return response.isAcknowledged();
    }

    @Override
    public boolean isIndexExist(String index) throws IOException {
        GetIndexRequest request = new GetIndexRequest(new String[]{index});
        return this.restHighLevelClient.indices().exists(request, RequestOptions.DEFAULT);
    }

    @Override
    public boolean deleteIndex(String index) throws IOException {
        if (!this.isIndexExist(index)) {
            log.error("Index is not exits!");
            return false;
        }
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        AcknowledgedResponse delete = this.restHighLevelClient.indices().delete(request, RequestOptions.DEFAULT);
        return delete.isAcknowledged();
    }

    @Override
    public boolean createIndexMapping(String index, List<String> fields) throws Exception {
        boolean b = this.isIndexExist(index);
        if (b) {
            this.deleteIndex(index);
        }
        if (!(b = this.createIndex(index))) {
            log.error("Index is create fail!");
            return false;
        }
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("properties");
        builder.startObject("esOnlyId").field("type", "keyword").endObject();
        for (String field : fields) {
            this.timeOrDate2Keyword(builder, field);
        }
        builder.endObject().endObject();
        return this.submitMapping(index, builder);
    }

    @Override
    public boolean createIndexMapping(String index, String field) throws Exception {
        boolean b = this.isIndexExist(index);
        if (!b) {
            log.error("Index is not exist!");
            return false;
        }
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("properties");
        this.timeOrDate2Keyword(builder, field);
        builder.endObject().endObject();
        return this.submitMapping(index, builder);
    }

    @Override
    public boolean createIndexMapping(String index, String nested, List<String> nestedFields) throws Exception {
        boolean b = this.isIndexExist(index);
        if (!b) {
            log.error("Index is not exist!");
            return false;
        }
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("properties");
        builder.startObject(nested).field("type", "nested").startObject("properties");
        for (String field : nestedFields) {
            this.timeOrDate2Keyword(builder, field);
        }
        builder.endObject().endObject();
        builder.endObject().endObject();
        return this.submitMapping(index, builder);
    }

    private boolean submitMapping(String index, XContentBuilder builder) throws IOException {
        PutMappingRequest mappingRequest = new PutMappingRequest(new String[]{index}).source(builder);
        AcknowledgedResponse acknowledgedResponse = this.restHighLevelClient.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
        return acknowledgedResponse.isAcknowledged();
    }

    private void timeOrDate2Keyword(XContentBuilder builder, String field) throws IOException {
        String time = "time";
        String dateFormat = "dateFormat";
        String status = "status";
        String stats = "stats";
        String type = "type";
        String id = "id";
        if (field.toLowerCase().endsWith(dateFormat.toLowerCase())) {
            builder.startObject(field).field("type", "date").field("format", "yyyy-MM-dd HH:mm:ss||yyyy-MM-dd||epoch_millis").endObject();
        } else if (field.toLowerCase().endsWith(time)) {
            builder.startObject(field).field("type", "keyword").endObject();
        } else if (StringUtils.equals((CharSequence)field.toLowerCase(), (CharSequence)status) || StringUtils.equals((CharSequence)field.toLowerCase(), (CharSequence)id) || field.toLowerCase().endsWith(type) || field.toLowerCase().endsWith(stats)) {
            builder.startObject(field).field("type", "integer").endObject();
        } else {
            builder.startObject(field).field("type", "text").field("analyzer", "ik_max_word").startObject("fields").startObject("keyword").field("type", "keyword").field("ignore_above", "256").endObject().startObject("standard").field("type", "text").field("analyzer", "standard").endObject().startObject("ngram").field("type", "text").field("analyzer", "ngram_analyzer").endObject().endObject().endObject();
        }
    }

    @Override
    public boolean submitData(String index, Object source, String esOnlyId) throws IOException {
        if (null == esOnlyId) {
            return this.addData(index, source);
        }
        if (this.existsById(index, esOnlyId)) {
            return this.updateDataByIdNoRealTime(index, source, esOnlyId);
        }
        return this.addData(index, source, esOnlyId);
    }

    @Override
    public boolean addData(String index, Object source, String esOnlyId) throws IOException {
        if (StringUtils.isBlank((CharSequence)esOnlyId)) {
            return this.addData(index, source);
        }
        if (this.existsById(index, esOnlyId)) {
            return this.updateDataByIdNoRealTime(index, source, esOnlyId);
        }
        IndexRequest request = new IndexRequest(index);
        request.id(esOnlyId);
        request.timeout(TimeValue.timeValueSeconds((long)1L));
        request.source(JSON.toJSONString((Object)source), XContentType.JSON);
        return this.addData(request);
    }

    @Override
    public boolean addData(String index, Object source) throws IOException {
        return this.addData(index, source, UUID.randomUUID().toString().replaceAll("-", "").toUpperCase());
    }

    @Override
    public boolean addData(IndexRequest request) throws IOException {
        IndexResponse response = this.restHighLevelClient.index(request, RequestOptions.DEFAULT);
        log.info("\u6dfb\u52a0\u6570\u636e\u6210\u529f \u7d22\u5f15\u4e3a: {}, response \u72b6\u6001: {}, esOnlyId\u4e3a: {}", new Object[]{response.getIndex(), response.status().getStatus(), response.getId()});
        return response.getId() != null;
    }

    @Override
    public boolean deleteDataById(String index, String esOnlyId) throws IOException {
        DeleteRequest request = new DeleteRequest(index, esOnlyId);
        DeleteResponse deleteResponse = this.restHighLevelClient.delete(request, RequestOptions.DEFAULT);
        return deleteResponse.getId() != null;
    }

    @Override
    public boolean updateDataById(String index, Object source, String esOnlyId) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(index, esOnlyId);
        updateRequest.timeout("1s");
        updateRequest.upsert(JSON.toJSONString((Object)source), XContentType.JSON);
        UpdateResponse updateResponse = this.restHighLevelClient.update(updateRequest, RequestOptions.DEFAULT);
        log.info("\u7d22\u5f15\u4e3a: {}, id\u4e3a: {},updateResponseID\uff1a{}, \u66f4\u65b0\u6570\u636e\u6210\u529f", new Object[]{index, esOnlyId, updateResponse.getId()});
        return updateResponse.getId() != null;
    }

    @Override
    public boolean updateDataByIdNoRealTime(String index, Object source, String esOnlyId) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(index, esOnlyId);
        updateRequest.setRefreshPolicy("wait_for");
        updateRequest.timeout("1s");
        updateRequest.doc(JSON.toJSONString((Object)source), XContentType.JSON);
        UpdateResponse updateResponse = this.restHighLevelClient.update(updateRequest, RequestOptions.DEFAULT);
        log.info("\u7d22\u5f15\u4e3a: {}, id\u4e3a: {},updateResponseID\uff1a{}, \u5b9e\u65f6\u66f4\u65b0\u6570\u636e\u6210\u529f", new Object[]{index, esOnlyId, updateResponse.getId()});
        return updateResponse.getId() != null;
    }

    @Override
    public boolean existsById(String index, String esOnlyId) throws IOException {
        GetRequest request = new GetRequest(index, esOnlyId);
        request.fetchSourceContext(new FetchSourceContext(false));
        request.storedFields(new String[]{"_none_"});
        return this.restHighLevelClient.exists(request, RequestOptions.DEFAULT);
    }

    @Override
    public boolean bulkPost(String index, List<Object> objects) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (Object source : objects) {
            IndexRequest request = new IndexRequest(index);
            request.source(JSON.toJSONString((Object)source), XContentType.JSON);
            bulkRequest.add(request);
        }
        BulkResponse response = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
        return null != response && response.hasFailures();
    }

    @Override
    public boolean bulkPost(BulkRequest bulkRequest) throws IOException {
        BulkResponse response = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
        return null != response && response.hasFailures();
    }

    @Override
    public boolean bulkPostAppointId(String index, List<Map<String, Object>> list) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (Map<String, Object> source : list) {
            IndexRequest request = new IndexRequest(index);
            request.id(source.get("esOnlyId").toString());
            request.source(JSON.toJSONString(source), XContentType.JSON);
            bulkRequest.add(request);
        }
        BulkResponse response = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
        return null != response && response.hasFailures();
    }
}

