/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.search.es.config;

import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class EsConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EsConfig.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(EsConfig.class);
    @Value(value="${spring.elasticsearch.rest.uris}")
    private String uris;
    @Value(value="${spring.elasticsearch.rest.connection-timeout}")
    private int connectTimeOut;
    @Value(value="${spring.elasticsearch.rest.max-connection}")
    private int maxConnection;
    private RestHighLevelClient restHighLevelClient;
    private Environment environment;

    public EsConfig(Environment environment) {
        this.environment = environment;
    }

    @Bean(name={"restHighLevelClient"})
    public RestHighLevelClient restHighLevelClient() {
        LOGGER.info("Elasticsearch\u521d\u59cb\u5316\u5f00\u59cb\u3002\u3002\u3002\u3002\u3002");
        try {
            if (this.restHighLevelClient != null) {
                this.restHighLevelClient.close();
            }
            if (StringUtils.isBlank((CharSequence)this.uris)) {
                log.error("spring.elasticsearch.rest.uris is blank");
                return null;
            }
            String userName = this.environment.getProperty("spring.elasticsearch.rest.username");
            String password = this.environment.getProperty("spring.elasticsearch.rest.password");
            String[] uriArr = this.uris.split(",");
            HttpHost[] httpHostArr = new HttpHost[uriArr.length];
            int i = 0;
            for (String uri : uriArr) {
                if (StringUtils.isEmpty((CharSequence)this.uris)) continue;
                try {
                    String[] split = uri.split(":");
                    String host = split[0];
                    String port = split[1];
                    HttpHost httpHost = new HttpHost(host, Integer.parseInt(port), "http");
                    httpHostArr[i++] = httpHost;
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
            RestClientBuilder builder = RestClient.builder((HttpHost[])httpHostArr);
            if (!StringUtils.isEmpty((CharSequence)userName)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
                builder.setHttpClientConfigCallback(arg_0 -> this.lambda$restHighLevelClient$0((CredentialsProvider)credentialsProvider, arg_0));
            }
            builder.setRequestConfigCallback(requestConfigBuilder -> {
                requestConfigBuilder.setConnectTimeout(this.connectTimeOut);
                return requestConfigBuilder;
            });
            this.restHighLevelClient = new RestHighLevelClient(builder);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        LOGGER.info("Elasticsearch\u521d\u59cb\u5316\u6210\u529f\u5e76\u7ed3\u675f\u3002\u3002\u3002\u3002\u3002");
        return this.restHighLevelClient;
    }

    private /* synthetic */ HttpAsyncClientBuilder lambda$restHighLevelClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setMaxConnTotal(this.maxConnection);
        httpClientBuilder.disableAuthCaching();
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        return httpClientBuilder;
    }
}

