/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.qiniu.driver;

import cn.jdevelops.file.OssOperateAPI;
import cn.jdevelops.file.bean.DownloadDTO;
import cn.jdevelops.file.bean.ExpireDateDTO;
import cn.jdevelops.file.bean.FilePathResult;
import cn.jdevelops.file.bean.RemoveFileDTO;
import cn.jdevelops.file.bean.UploadDTO;
import cn.jdevelops.file.config.OSSConfig;
import cn.jdevelops.file.util.UrlUtil;
import com.google.gson.Gson;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.DownloadUrl;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QiniuOperate
implements OssOperateAPI {
    private static final Logger LOG = LoggerFactory.getLogger(QiniuOperate.class);
    @Autowired
    private OSSConfig ossConfig;
    @Autowired
    private UploadManager uploadManager;
    @Autowired
    private BucketManager bucketManager;
    @Autowired
    private Auth auth;

    public FilePathResult uploadFile(UploadDTO uploaded) throws Exception {
        String originalFilename = uploaded.getFile().getOriginalFilename();
        String updateFile = uploaded.getChildFolder() + originalFilename;
        Response response = this.uploadManager.put(uploaded.getFile().getInputStream(), updateFile, this.getUploadToken(uploaded.getBucket()), null, null);
        Gson gson = new Gson();
        DefaultPutRet defaultPutRet = (DefaultPutRet)gson.fromJson(response.bodyString(), DefaultPutRet.class);
        return FilePathResult.builder().freshName(originalFilename).absolutePath(updateFile).originalName(originalFilename).relativePath(this.ossConfig.getBrowseUrl() + "/" + updateFile).build();
    }

    public void downloadFile(HttpServletResponse response, DownloadDTO download) throws Exception {
        String encodeName = URLEncoder.encode(download.getChildFolder_FreshName(), "UTF-8").replaceAll("\\+", "%20");
        String urlString = this.ossConfig.getBrowseUrl() + "/" + encodeName;
        String downloadRUL = this.auth.privateDownloadUrl(urlString, 3600L);
        String childFolder_freshName = download.getChildFolder_FreshName();
        String fileName = childFolder_freshName.substring(childFolder_freshName.lastIndexOf(47) + 1);
        try {
            URL url = new URL(downloadRUL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            response.reset();
            response.setContentType(UrlUtil.getContentType((String)downloadRUL) + ";charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20"));
            response.setHeader("Content-Length", String.valueOf(url.openConnection().getContentLength()));
            IOUtils.copy((InputStream)conn.getInputStream(), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String expireDateUrl(ExpireDateDTO expireDate) throws Exception {
        String browseUrl = this.ossConfig.getBrowseUrl();
        DownloadUrl url = new DownloadUrl(browseUrl.substring(browseUrl.indexOf("//") + 1), this.ossConfig.getQiniu().getHttps().booleanValue(), expireDate.getChildFolder_FreshName());
        long expireInSeconds = expireDate.getExpires().intValue();
        return url.buildURL(this.auth, expireInSeconds);
    }

    public void removeFiles(RemoveFileDTO remove) throws Exception {
        try {
            List childFolder_freshName = remove.getChildFolder_FreshName();
            for (String file : childFolder_freshName) {
                try {
                    this.bucketManager.delete(remove.getBucket(), file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getUploadToken(String bucket) {
        StringMap policy = new StringMap();
        return this.auth.uploadToken(bucket, null, 3600L, policy);
    }
}

