/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.qiniu.driver;

import cn.jdevelops.file.config.OSSConfig;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EnableAutoScanConfiguration {
    @ConditionalOnMissingBean(name={"ossConfig"})
    @Bean
    public OSSConfig ossConfig() {
        return new OSSConfig();
    }

    @Bean
    public com.qiniu.storage.Configuration qiniuConfig(OSSConfig ossConfig) {
        Region region;
        switch (ossConfig.getQiniu().getRegionId()) {
            case "z0": {
                region = Region.region1();
                break;
            }
            case "z1": {
                region = Region.region1();
                break;
            }
            case "na0": {
                region = Region.regionNa0();
                break;
            }
            case "as0": {
                region = Region.regionAs0();
                break;
            }
            case "fog-cn-east-1": {
                region = Region.regionFogCnEast1();
                break;
            }
            case "cn-east-2": {
                region = Region.regionCnEast2();
                break;
            }
            default: {
                region = Region.region2();
            }
        }
        return new com.qiniu.storage.Configuration(region);
    }

    @Bean
    public UploadManager uploadManager(OSSConfig ossConfig) {
        return new UploadManager(this.qiniuConfig(ossConfig));
    }

    @Bean
    public Auth auth(OSSConfig ossConfig) {
        return Auth.create((String)ossConfig.getQiniu().getAccessKey(), (String)ossConfig.getQiniu().getSecretKey());
    }

    @Bean
    public BucketManager bucketManager(OSSConfig ossConfig) {
        return new BucketManager(this.auth(ossConfig), this.qiniuConfig(ossConfig));
    }
}

