/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.minio.driver;

import cn.jdevelops.file.bean.FilePathResult;
import cn.jdevelops.file.config.OSSConfig;
import cn.jdevelops.file.util.StrUtil;
import cn.jdevelops.minio.driver.AboutFileUtil;
import io.minio.BucketExistsArgs;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.SetBucketPolicyArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.web.multipart.MultipartFile;

public class OperateFileUtil {
    private final MinioClient minioClient;
    private final OSSConfig ossConfig;

    public OperateFileUtil(MinioClient minioClient, OSSConfig minIoConfig) {
        this.minioClient = minioClient;
        this.ossConfig = minIoConfig;
    }

    public boolean bucketExists(String bucket) throws Exception {
        return this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucket)).build());
    }

    public void makeBucket(String bucket) throws Exception {
        boolean found = this.bucketExists(bucket);
        if (!found) {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucket)).build());
            String str = " {\n     \"Statement\": [\n         {\n             \"Action\": [\n                 \"s3:GetBucketLocation\",\n                 \"s3:ListBucket\"\n             ],\n             \"Effect\": \"Allow\",\n             \"Principal\": \"*\",\n             \"Resource\": \"arn:aws:s3:::" + bucket + "\"\n         },\n         {\n             \"Action\": \"s3:GetObject\",\n             \"Effect\": \"Allow\",\n             \"Principal\": \"*\",\n             \"Resource\": \"arn:aws:s3:::" + bucket + "/*\"\n         }\n     ],\n     \"Version\": \"2012-10-17\"\n }";
            this.minioClient.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucket)).config(str).build());
        }
    }

    public List<Bucket> listBuckets() throws Exception {
        return this.minioClient.listBuckets();
    }

    public void removeBucket(String bucketName) throws Exception {
        this.minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
    }

    public FilePathResult uploadFile(MultipartFile file, String fileName, String bucket, String childFolder) throws Exception {
        this.makeBucket(bucket);
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String filename = sdf.format(date).trim();
        Objects.requireNonNull(file.getOriginalFilename());
        String originalName = file.getOriginalFilename();
        String fileType = AboutFileUtil.getFileSuffix(originalName);
        String freshName = StrUtil.notBlank((String)fileName) ? fileName.trim() + "." + fileType : filename + "." + fileType;
        if (StringUtils.isNotBlank((CharSequence)childFolder) && !StringUtils.equalsIgnoreCase((CharSequence)"null", (CharSequence)childFolder)) {
            freshName = childFolder + freshName;
        }
        InputStream in = file.getInputStream();
        String contentType = file.getContentType();
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(freshName)).stream(in, (long)in.available(), -1L).contentType(contentType).build());
        in.close();
        String relativePath = bucket + "/" + freshName;
        return FilePathResult.builder().absolutePath(this.ossConfig.getBrowseUrl() + "/" + relativePath).relativePath(relativePath).freshName(freshName).originalName(originalName).build();
    }

    public FilePathResult uploadFile(String objJson, String bucket, String objectName) throws Exception {
        this.makeBucket(bucket);
        ByteArrayInputStream basis = new ByteArrayInputStream(objJson.getBytes(StandardCharsets.UTF_8));
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(objectName)).stream((InputStream)basis, (long)basis.available(), -1L).contentType("application/octet-stream").build());
        basis.close();
        String relativePath = bucket + "/" + objectName;
        return FilePathResult.builder().absolutePath(this.ossConfig.getBrowseUrl() + "/" + relativePath).relativePath(relativePath).freshName(objectName).originalName(objectName).build();
    }

    public Iterable<Result<Item>> listObjects(String bucket, String childFolder) throws Exception {
        return this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucket)).prefix(childFolder).build());
    }

    public Iterable<Result<Item>> allListObjects(String bucket, String childFolder) throws Exception {
        return this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucket)).prefix(childFolder).recursive(true).build());
    }

    public StatObjectResponse statObject(String bucket, String objectName) throws Exception {
        boolean found = this.bucketExists(bucket);
        if (!found) {
            throw new RuntimeException("\u6876\u4e0d\u5b58\u5728\uff01");
        }
        return this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucket)).object(objectName)).build());
    }

    public InputStream getObject(String bucket, String objectName) throws Exception {
        boolean found = this.bucketExists(bucket);
        if (!found) {
            throw new RuntimeException("\u6876\u4e0d\u5b58\u5728\uff01");
        }
        return this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(objectName)).build());
    }

    public void copyObject(String bucket, String objectName, String sourceBucket, String sourceObjectName) throws Exception {
        this.minioClient.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(bucket)).object(objectName)).source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(sourceBucket)).object(sourceObjectName)).build()).build());
    }

    public void download(HttpServletResponse response, String bucket, String objectName) throws Exception {
        boolean found = this.bucketExists(bucket);
        if (!found) {
            throw new RuntimeException("\u6876\u4e0d\u5b58\u5728\uff01");
        }
        objectName = this.verifyObjectName(bucket, objectName);
        StatObjectResponse statObjectResponse = this.statObject(bucket, objectName);
        response.setContentType(statObjectResponse.contentType());
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(statObjectResponse.object(), "UTF-8"));
        InputStream inputStream = this.getObject(bucket, objectName);
        response.setHeader("Content-Length", String.valueOf(statObjectResponse.size()));
        IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        inputStream.close();
    }

    public String getExpiryObjectUrl(String bucket, String objectName, Integer expires) throws Exception {
        boolean found = this.bucketExists(bucket);
        if (!found) {
            throw new RuntimeException("\u6876\u4e0d\u5b58\u5728\uff01");
        }
        objectName = this.verifyObjectName(bucket, objectName);
        return this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucket)).object(objectName)).expiry(expires.intValue(), TimeUnit.SECONDS).build());
    }

    public void removeObject(String bucket, String objectName) throws Exception {
        boolean flag = this.bucketExists(bucket);
        if (flag) {
            objectName = this.verifyObjectName(bucket, objectName);
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucket)).object(objectName)).build());
        }
    }

    public List<String> removeObjects(String bucket, List<String> objectNames) throws Exception {
        boolean flag = this.bucketExists(bucket);
        ArrayList<String> deleteErrorNames = new ArrayList<String>();
        if (flag) {
            LinkedList<DeleteObject> objects = new LinkedList<DeleteObject>();
            for (String objectName : objectNames) {
                objectName = this.verifyObjectName(bucket, objectName);
                objects.add(new DeleteObject(objectName));
            }
            Iterable results = this.minioClient.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucket)).objects(objects).build());
            for (Result result : results) {
                DeleteError error = (DeleteError)result.get();
                deleteErrorNames.add(error.objectName());
            }
        }
        return deleteErrorNames;
    }

    private String verifyObjectName(String bucket, String objectName) {
        String replace = this.ossConfig.getBrowseUrl() + "/" + bucket + "/";
        return objectName.replaceFirst(replace, "");
    }
}

