/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.minio.driver;

import cn.jdevelops.file.OssOperateAPI;
import cn.jdevelops.file.bean.DownloadDTO;
import cn.jdevelops.file.bean.ExpireDateDTO;
import cn.jdevelops.file.bean.FilePathResult;
import cn.jdevelops.file.bean.RemoveFileDTO;
import cn.jdevelops.file.bean.UploadDTO;
import cn.jdevelops.file.bean.UploadsDTO;
import cn.jdevelops.minio.driver.OperateFileUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MinioOperate
implements OssOperateAPI {
    private static final Logger LOG = LoggerFactory.getLogger(MinioOperate.class);
    @Autowired
    private OperateFileUtil operateFileUtil;

    public FilePathResult uploadFile(UploadDTO uploaded) throws Exception {
        return this.operateFileUtil.uploadFile(uploaded.getFile(), uploaded.getFileName(), uploaded.getBucket(), uploaded.getChildFolder());
    }

    public List<FilePathResult> uploadFile(UploadsDTO uploaded) throws Exception {
        ArrayList<FilePathResult> results = new ArrayList<FilePathResult>();
        uploaded.getFiles().forEach(file -> {
            try {
                UploadDTO uploadDTO = new UploadDTO();
                uploadDTO.setFile(file.getFile());
                uploadDTO.setFileName(file.getFileName());
                uploadDTO.setBucket(uploaded.getBucket());
                uploadDTO.setChildFolder(uploaded.getChildFolder());
                results.add(this.uploadFile(uploadDTO));
            }
            catch (Exception e) {
                LOG.error("\u6279\u91cf\u4e0a\u4f20\u6709\u6570\u636e\u62a5\u9519\uff0c\u53ef\u5ffd\u7565", (Throwable)e);
            }
        });
        return results;
    }

    public void downloadFile(HttpServletResponse response, DownloadDTO download) throws Exception {
        this.operateFileUtil.download(response, download.getBucket(), download.getChildFolder_FreshName());
    }

    public String expireDateUrl(ExpireDateDTO expireDate) throws Exception {
        return this.operateFileUtil.getExpiryObjectUrl(expireDate.getBucket(), expireDate.getChildFolder_FreshName(), expireDate.getExpires());
    }

    public void removeFiles(RemoveFileDTO remove) throws Exception {
        this.operateFileUtil.removeObjects(remove.getBucket(), remove.getChildFolder_FreshName());
    }
}

