/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.minio.driver;

import java.io.File;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AboutFileUtil.class);
    public static final String[] IMG_FILE = new String[]{"bmp", "jpg", "png", "tif", "gif", "jpeg", "webp"};
    public static final String[] DOC_FILE = new String[]{"doc", "docx", "txt", "hlp", "wps", "rtf", "xls", "xlsx", "ppt", "pptx", "java", "html", "pdf", "md", "sql", "css", "js", "vue", "java"};
    public static final String[] VIDEO_FILE = new String[]{"avi", "mp4", "mpg", "mov", "swf", "3gp", "rm", "rmvb", "wmv", "mkv"};
    public static final String[] MUSIC_FILE = new String[]{"wav", "aif", "au", "mp3", "ram", "wma", "mmf", "amr", "aac", "flac"};
    public static String[] ALL_FILE = new String[1];

    public static void creatFile(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            LOG.error("\u8be5\u76ee\u5f55\u4e0d\u5b58\u5728");
        } else {
            file.mkdir();
        }
    }

    public static String getFileSuffix(String filename) {
        String suffix = filename.substring(filename.lastIndexOf(".") + 1);
        return suffix;
    }

    public static boolean isSafe(String suffix) {
        suffix = suffix.toLowerCase();
        for (String s : ALL_FILE) {
            if (!s.equals(suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPic(String suffix) {
        suffix = suffix.toLowerCase();
        for (String s : IMG_FILE) {
            if (!s.equals(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String getFileStringSize(long fileSize) {
        double temp = 0.0;
        String size = "";
        temp = (double)fileSize / 1024.0;
        if (temp >= 1024.0) {
            if ((temp /= 1024.0) >= 1024.0) {
                size = (temp /= 1024.0) + "000";
                size = size.substring(0, size.indexOf(".") + 3) + "GB";
            } else {
                size = temp + "000";
                size = size.substring(0, size.indexOf(".") + 3) + "MB";
            }
        } else {
            size = temp + "000";
            size = size.substring(0, size.indexOf(".") + 3) + "KB";
        }
        return size;
    }

    static {
        ALL_FILE = (String[])ArrayUtils.addAll((Object[])ALL_FILE, (Object[])IMG_FILE);
        ALL_FILE = (String[])ArrayUtils.addAll((Object[])ALL_FILE, (Object[])DOC_FILE);
        ALL_FILE = (String[])ArrayUtils.addAll((Object[])ALL_FILE, (Object[])VIDEO_FILE);
        ALL_FILE = (String[])ArrayUtils.addAll((Object[])ALL_FILE, (Object[])MUSIC_FILE);
    }
}

