/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.util.interceptor.util;

import cn.jdevelops.util.interceptor.util.StrUtil;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RequestUtil.class);

    public static String requestParams(HttpServletRequest request) {
        String queryString = RequestUtil.queryString(request);
        return StrUtil.isNull(queryString) ? RequestUtil.bodyString(request) : queryString;
    }

    public static String queryString(HttpServletRequest request) {
        HashMap<String, String> paramMap = new HashMap<String, String>(10);
        Enumeration keys = request.getParameterNames();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key == null || !(key instanceof String)) continue;
            String value = request.getParameter(key.toString());
            paramMap.put(key.toString(), value);
        }
        return paramMap.isEmpty() ? "" : new Gson().toJson(paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBodyString(ServletRequest request) {
        StringBuilder sb = new StringBuilder();
        ServletInputStream inputStream = null;
        BufferedReader reader = null;
        try {
            String line;
            inputStream = request.getInputStream();
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            LOG.debug("\u8bfb\u53d6\u6d41\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.debug("\u5173\u95ed\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.debug("\u5173\u95ed\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    public static String bodyString(HttpServletRequest request) {
        StringBuilder param = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                param.append(line);
            }
            reader.close();
        }
        catch (IOException e) {
            LOG.debug("\u83b7\u53d6 @RequestBody \u76f8\u5173\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        return StrUtil.isNull(param) ? "" : param.toString();
    }

    public static boolean isMultipartContent(HttpServletRequest request) {
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("MULTIPART/".toLowerCase());
    }
}

