/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.util.interceptor.util;

import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import org.springframework.web.method.HandlerMethod;

public class HandlerUtil {
    public static <A extends Annotation> Optional<A> classAnnotation(Object handler, Class<A> annotationClass) {
        Objects.requireNonNull(annotationClass);
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            return Optional.ofNullable(method.getMethod().getDeclaringClass().getAnnotation(annotationClass));
        }
        return Optional.empty();
    }

    public static <A extends Annotation> Optional<A> methodAnnotation(Object handler, Class<A> annotationClass) {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            return Optional.ofNullable(method.getMethodAnnotation(annotationClass));
        }
        return Optional.empty();
    }
}

