/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.util.interceptor.core;

import cn.jdevelops.util.interceptor.api.ApiAfterInterceptor;
import cn.jdevelops.util.interceptor.api.ApiAsyncInterceptor;
import cn.jdevelops.util.interceptor.api.ApiBeforeInterceptor;
import cn.jdevelops.util.interceptor.api.ApiFinallyInterceptor;
import cn.jdevelops.util.interceptor.api.ApiInterceptor;
import cn.jdevelops.util.interceptor.chain.ApiAfterInterceptorChain;
import cn.jdevelops.util.interceptor.chain.ApiAsyncInterceptorChain;
import cn.jdevelops.util.interceptor.chain.ApiBeforeInterceptorChain;
import cn.jdevelops.util.interceptor.chain.ApiFinallyInterceptorChain;
import cn.jdevelops.util.interceptor.chain.ApiInterceptorChain;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
public class JdevelopsWebMvcConfig
implements WebMvcConfigurer {
    private final List<ApiAfterInterceptor> afterInterceptors;
    private final List<ApiAsyncInterceptor> asyncInterceptors;
    private final List<ApiBeforeInterceptor> beforeInterceptors;
    private final List<ApiFinallyInterceptor> finallyInterceptors;
    private final List<ApiInterceptor> apiInterceptors;

    public JdevelopsWebMvcConfig(List<ApiAfterInterceptor> afterInterceptors, List<ApiAsyncInterceptor> asyncInterceptors, List<ApiBeforeInterceptor> beforeInterceptors, List<ApiFinallyInterceptor> finallyInterceptors, List<ApiInterceptor> apiInterceptors) {
        this.afterInterceptors = Objects.isNull(afterInterceptors) ? new ArrayList() : afterInterceptors;
        this.asyncInterceptors = Objects.isNull(asyncInterceptors) ? new ArrayList() : asyncInterceptors;
        this.beforeInterceptors = Objects.isNull(beforeInterceptors) ? new ArrayList() : beforeInterceptors;
        this.finallyInterceptors = Objects.isNull(finallyInterceptors) ? new ArrayList() : finallyInterceptors;
        this.apiInterceptors = Objects.isNull(apiInterceptors) ? new ArrayList() : apiInterceptors;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new HandlerInterceptor(){

            public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                ApiBeforeInterceptorChain beforeChain = new ApiBeforeInterceptorChain(JdevelopsWebMvcConfig.this.beforeInterceptors);
                return beforeChain.execute(request, response, handler);
            }

            public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
                ApiAfterInterceptorChain afterChain = new ApiAfterInterceptorChain(JdevelopsWebMvcConfig.this.afterInterceptors);
                afterChain.execute(request, response, handler, modelAndView);
            }

            public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
                ApiFinallyInterceptorChain finallyChain = new ApiFinallyInterceptorChain(JdevelopsWebMvcConfig.this.finallyInterceptors);
                finallyChain.execute(request, response, handler, ex);
            }
        });
        ApiInterceptorChain apiChains = new ApiInterceptorChain(this.apiInterceptors);
        apiChains.execute().forEach(arg_0 -> ((InterceptorRegistry)registry).addInterceptor(arg_0));
        registry.addInterceptor((HandlerInterceptor)new AsyncHandlerInterceptor(){

            public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                ApiAsyncInterceptorChain asyncInterceptor = new ApiAsyncInterceptorChain(JdevelopsWebMvcConfig.this.asyncInterceptors);
                asyncInterceptor.execute(request, response, handler);
            }
        });
    }
}

