/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.util.interceptor.chain;

import cn.jdevelops.util.interceptor.api.ApiInterceptor;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class ApiInterceptorChain {
    private final List<ApiInterceptor> interceptors;

    public ApiInterceptorChain(List<ApiInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public List<HandlerInterceptor> execute() {
        ArrayList<HandlerInterceptor> handlerInterceptors = new ArrayList<HandlerInterceptor>();
        for (final ApiInterceptor chain : this.interceptors) {
            handlerInterceptors.add(new HandlerInterceptor(){

                public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                    return chain.before(request, response, handler);
                }

                public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
                    chain.after(request, response, handler, modelAndView);
                }

                public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
                    chain.finallys(request, response, handler, ex);
                }
            });
        }
        return handlerInterceptors;
    }
}

