/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.util.authorization.error.respone;

import cn.hutool.json.JSONUtil;
import cn.jdevelops.api.result.emums.ExceptionCode;
import cn.jdevelops.api.result.emums.TokenExceptionCode;
import cn.jdevelops.api.result.response.ResultVO;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;

public class ResponseUtil {
    public static String getExceptionMessage(Exception e) {
        String message;
        if (e instanceof OAuth2AuthenticationException) {
            OAuth2AuthenticationException o = (OAuth2AuthenticationException)e;
            message = o.getError().getDescription();
            if (null == message || message.isEmpty()) {
                message = o.getError().getErrorCode();
            }
        } else {
            message = e.getMessage();
        }
        return message;
    }

    public static void exceptionResponse(HttpServletResponse response, Exception e) throws AccessDeniedException, AuthenticationException, IOException {
        ResponseUtil.exceptionResponse(response, new ExceptionCode(TokenExceptionCode.TOKEN_ERROR.getCode(), ResponseUtil.getExceptionMessage(e)));
    }

    public static void exceptionResponse(HttpServletResponse response, ExceptionCode tokenError) throws AccessDeniedException, AuthenticationException, IOException {
        ResultVO fail = ResultVO.of((ExceptionCode)tokenError);
        String jsonStr = JSONUtil.toJsonStr((Object)fail);
        response.setStatus(200);
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.getWriter().print(jsonStr);
    }
}

