/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.util.authorization.error.core;

import cn.jdevelops.api.result.emums.ExceptionCode;
import cn.jdevelops.api.result.emums.TokenExceptionCode;
import cn.jdevelops.util.authorization.error.respone.ResponseUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

public class UnAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private String loginFormUrl;
    private static final Logger logger = LoggerFactory.getLogger(UnAuthenticationEntryPoint.class);

    public UnAuthenticationEntryPoint(String loginFormUrl) {
        this.loginFormUrl = loginFormUrl;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (response.isCommitted()) {
            return;
        }
        ExceptionCode tokenError = TokenExceptionCode.TOKEN_ERROR;
        if (authException instanceof InvalidBearerTokenException) {
            logger.warn("\u4ee4\u724c\u65e0\u6548\u6216\u5df2\u8fc7\u671f");
            ResponseUtil.exceptionResponse(response, tokenError);
        } else if (authException instanceof InsufficientAuthenticationException) {
            String accept = request.getHeader("accept");
            if (accept.contains("text/html")) {
                LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint = new LoginUrlAuthenticationEntryPoint(this.loginFormUrl);
                loginUrlAuthenticationEntryPoint.commence(request, response, authException);
            } else {
                ResponseUtil.exceptionResponse(response, new ExceptionCode(tokenError.getCode(), "\u4ee4\u724c\u4e0d\u80fd\u4e3a\u7a7a"));
            }
        } else {
            ResponseUtil.exceptionResponse(response, new ExceptionCode(tokenError.getCode(), ResponseUtil.getExceptionMessage((Exception)authException)));
        }
    }
}

