/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.sms.aliyun.config;

import cn.jdevelops.sms.aliyun.config.SmsConfig;
import cn.jdevelops.sms.aliyun.service.AliYunService;
import cn.jdevelops.sms.aliyun.service.impl.AliYunServiceImpl;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.teaopenapi.models.Config;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SmsConfig.class})
public class SmsConfiguration {
    private final SmsConfig smsConfig;

    public SmsConfiguration(SmsConfig smsConfig) {
        this.smsConfig = smsConfig;
    }

    @Bean
    public Client getClient() throws Exception {
        Config config = new Config().setAccessKeyId(this.smsConfig.getAccessKeyId()).setAccessKeySecret(this.smsConfig.getAccessKeySecret());
        config.setEndpoint("dysmsapi.aliyuncs.com");
        return new Client(config);
    }

    @Bean
    public AliYunService aliYunSmsService(Client client) {
        return new AliYunServiceImpl(client);
    }
}

