/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.sboot.swagger.domain;

import cn.jdevelops.sboot.swagger.core.entity.SwaggerSecurityScheme;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="jdevelops.swagger")
public class SwaggerProperties {
    private List<String> basePackage;
    private String title;
    private String description;
    private String version;
    private String author;
    private String url;
    private String email;
    private String license;
    private String licenseUrl;
    private String groupName;
    private String displayName;
    private List<SwaggerSecurityScheme> swaggerSecuritySchemes;
    private Boolean securitySchemeDefault;

    public String toString() {
        return "SwaggerProperties{basePackage=" + this.basePackage + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", version='" + this.version + '\'' + ", author='" + this.author + '\'' + ", url='" + this.url + '\'' + ", email='" + this.email + '\'' + ", license='" + this.license + '\'' + ", licenseUrl='" + this.licenseUrl + '\'' + ", groupName='" + this.groupName + '\'' + ", displayName='" + this.displayName + '\'' + ", swaggerSecuritySchemes=" + this.swaggerSecuritySchemes + ", securitySchemeDefault=" + this.securitySchemeDefault + '}';
    }

    public List<String> getBasePackage() {
        if (Objects.isNull(this.basePackage)) {
            return Collections.singletonList("cn.jdevelops.controller");
        }
        return this.basePackage;
    }

    public void setBasePackage(List<String> basePackage) {
        this.basePackage = basePackage;
    }

    public String getTitle() {
        if (Objects.isNull(this.title)) {
            return "JdevelopsAPIs";
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        if (Objects.isNull(this.description)) {
            return "\u8be6\u7ec6\u63cf\u8ff0";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        if (Objects.isNull(this.version)) {
            return "2.0.7";
        }
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAuthor() {
        if (Objects.isNull(this.author)) {
            return "tan";
        }
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getUrl() {
        if (Objects.isNull(this.url)) {
            return "https://tannn.cn/";
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getEmail() {
        if (Objects.isNull(this.email)) {
            return "1445763190@qq.com";
        }
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getLicense() {
        if (Objects.isNull(this.license)) {
            return "tan";
        }
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        if (Objects.isNull(this.licenseUrl)) {
            return "https://tannn.cn/";
        }
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String getGroupName() {
        if (Objects.isNull(this.groupName)) {
            return "jdevelopsAPI";
        }
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getDisplayName() {
        if (Objects.isNull(this.displayName)) {
            return "\u9ed8\u8ba4\u63a5\u53e3\u7ec4";
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List<SwaggerSecurityScheme> getSwaggerSecuritySchemes() {
        List collect;
        if (Objects.isNull(this.swaggerSecuritySchemes) || this.swaggerSecuritySchemes.isEmpty()) {
            if (Boolean.TRUE.equals(this.getSecuritySchemeDefault())) {
                return Collections.singletonList(new SwaggerSecurityScheme(new SecurityScheme().type(SecurityScheme.Type.APIKEY).name("token").in(SecurityScheme.In.HEADER), true));
            }
            return new ArrayList<SwaggerSecurityScheme>();
        }
        if (Boolean.TRUE.equals(this.getSecuritySchemeDefault()) && (collect = this.swaggerSecuritySchemes.stream().filter(SwaggerSecurityScheme::getSecurity).collect(Collectors.toList())).isEmpty()) {
            return Collections.singletonList(new SwaggerSecurityScheme(new SecurityScheme().type(SecurityScheme.Type.APIKEY).name("token").in(SecurityScheme.In.HEADER), true));
        }
        return this.swaggerSecuritySchemes;
    }

    public void setSwaggerSecuritySchemes(List<SwaggerSecurityScheme> swaggerSecuritySchemes) {
        this.swaggerSecuritySchemes = swaggerSecuritySchemes;
    }

    public Boolean getSecuritySchemeDefault() {
        if (Objects.isNull(this.securitySchemeDefault)) {
            return true;
        }
        return this.securitySchemeDefault;
    }

    public void setSecuritySchemeDefault(Boolean securitySchemeDefault) {
        this.securitySchemeDefault = securitySchemeDefault;
    }
}

