/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.sboot.swagger.core.util;

import cn.jdevelops.sboot.swagger.core.entity.BuildSecuritySchemes;
import cn.jdevelops.sboot.swagger.core.entity.SwaggerSecurityScheme;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerUtil.class);

    public static String[] basePackages(List<String> basePackage) {
        return basePackage.toArray(new String[basePackage.size()]);
    }

    public static String getRealIp() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp() || !netInterface.getDisplayName().contains("Intel") && !netInterface.getDisplayName().contains("Realtek")) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
                break block2;
            }
        }
        catch (SocketException e) {
            LOG.error("\u83b7\u53d6\u4e3b\u673aip\u5730\u5740\u65f6\u51fa\u9519{}", (Object)e.getMessage());
        }
        return "127.0.0.1";
    }

    public static BuildSecuritySchemes buildSecuritySchemes(List<SwaggerSecurityScheme> swaggerSecuritySchemes) {
        ArrayList<SecurityRequirement> securityItem = new ArrayList<SecurityRequirement>();
        HashMap<String, SecurityScheme> securitySchemes = new HashMap<String, SecurityScheme>(10);
        swaggerSecuritySchemes.forEach(swaggerSecurityScheme -> {
            if (Boolean.TRUE.equals(swaggerSecurityScheme.getSecurity())) {
                securitySchemes.put(swaggerSecurityScheme.getScheme().getType().name(), swaggerSecurityScheme.getScheme());
                securityItem.add(new SecurityRequirement().addList(swaggerSecurityScheme.getScheme().getType().name()));
            }
        });
        return new BuildSecuritySchemes(securityItem, securitySchemes);
    }
}

