/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.sboot.swagger.config;

import cn.jdevelops.sboot.swagger.config.ConsoleConfig;
import cn.jdevelops.sboot.swagger.core.entity.BuildSecuritySchemes;
import cn.jdevelops.sboot.swagger.core.entity.SwaggerSecurityScheme;
import cn.jdevelops.sboot.swagger.core.util.RandomUtil;
import cn.jdevelops.sboot.swagger.core.util.SwaggerUtil;
import cn.jdevelops.sboot.swagger.domain.SwaggerProperties;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import java.util.HashMap;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@ConditionalOnWebApplication
@Import(value={ConsoleConfig.class, SwaggerProperties.class, SwaggerSecurityScheme.class})
@ConditionalOnClass(value={OpenAPI.class})
public class SwaggerConfig {
    @Bean
    public GlobalOpenApiCustomizer orderGlobalOpenApiCustomizer() {
        return openApi -> {
            if (openApi.getTags() != null) {
                openApi.getTags().forEach(tag -> {
                    HashMap<String, Integer> extensions = tag.getExtensions();
                    if (extensions == null || extensions.isEmpty()) {
                        extensions = new HashMap<String, Integer>(10);
                        extensions.put("x-order", RandomUtil.randomInt(0, 100));
                    }
                    tag.setExtensions(extensions);
                });
            }
            if (openApi.getPaths() != null) {
                openApi.addExtension("x-test123", (Object)"333");
                openApi.getPaths().addExtension("x-abb", (Object)RandomUtil.randomInt(1, 100));
            }
        };
    }

    @Bean
    public GroupedOpenApi defaultApi(SwaggerProperties swaggerProperties) {
        BuildSecuritySchemes buildSecuritySchemes = SwaggerUtil.buildSecuritySchemes(swaggerProperties.getSwaggerSecuritySchemes());
        String[] paths = new String[]{"/**"};
        String[] packagedToMatch = SwaggerUtil.basePackages(swaggerProperties.getBasePackage());
        return GroupedOpenApi.builder().group(swaggerProperties.getGroupName()).displayName(swaggerProperties.getDisplayName()).pathsToMatch(paths).addOperationCustomizer((operation, handlerMethod) -> operation.security(buildSecuritySchemes.getSecurityItem())).packagesToScan(packagedToMatch).build();
    }

    @Bean
    public OpenAPI customOpenAPI(SwaggerProperties swaggerProperties) {
        BuildSecuritySchemes buildSecuritySchemes = SwaggerUtil.buildSecuritySchemes(swaggerProperties.getSwaggerSecuritySchemes());
        OpenAPI openAPI = new OpenAPI().components(new Components().securitySchemes(buildSecuritySchemes.getSecuritySchemes())).info(new Info().title(swaggerProperties.getTitle()).version(swaggerProperties.getVersion()).contact(new Contact().name(swaggerProperties.getAuthor()).url(swaggerProperties.getUrl()).email(swaggerProperties.getEmail())).description(swaggerProperties.getDescription()).termsOfService(swaggerProperties.getUrl()).license(new License().name(swaggerProperties.getLicense()).url(swaggerProperties.getUrl())));
        buildSecuritySchemes.getSecurityItem().forEach(arg_0 -> ((OpenAPI)openAPI).addSecurityItem(arg_0));
        return openAPI;
    }
}

