/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.sboot.swagger.config;

import cn.jdevelops.sboot.swagger.core.util.SwaggerUtil;
import cn.jdevelops.sboot.swagger.domain.SwaggerProperties;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class ConsoleConfig
implements ApplicationRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleConfig.class);
    @Value(value="${server.port:8080}")
    private int serverPort;
    @Value(value="${server.servlet.context-path:/}")
    private String serverName;
    @Resource
    private SwaggerProperties swaggerBean;

    public void run(ApplicationArguments args) {
        try {
            if ("/".equals(this.serverName)) {
                this.serverName = "";
            }
            String groupStr = "";
            String groupName = this.swaggerBean.getGroupName();
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                groupStr = "?group=" + this.swaggerBean.getGroupName();
            }
            LOG.info("\n----------------------------------------------------------\n\t swagger \u542f\u52a8. Access URLs:\n\tswagger \u542f\u52a8\u6210\u529f\uff01\u63a5\u53e3\u6587\u6863\u5730\u5740(cloud\u6ca1\u6709\u9875\u9762)-HTML: (http://" + SwaggerUtil.getRealIp() + ":" + this.serverPort + this.serverName + "/doc.html)\n\tswagger \u542f\u52a8\u6210\u529f\uff01\u63a5\u53e3\u6587\u6863\u5730\u5740-JSON: (http://" + SwaggerUtil.getRealIp() + ":" + this.serverPort + this.serverName + "/v2/api-docs" + groupStr + ")\n\tswagger \u542f\u52a8\u6210\u529f\uff01\u63a5\u53e3\u6587\u6863\u5730\u5740-OpenApi-JSON: (http://" + SwaggerUtil.getRealIp() + ":" + this.serverPort + this.serverName + "/v3/api-docs" + groupStr + ")\n\t----------------------------------------------------------");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

