/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.event.redis.config;

import cn.jdevelops.event.redis.config.RedisEventConfig;
import cn.jdevelops.event.redis.receiver.RedisReceiver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.stereotype.Component;

@Component
@EnableCaching
public class RedisCacheListen {
    private static final Logger LOG = LoggerFactory.getLogger(RedisCacheListen.class);
    @Autowired
    private RedisEventConfig reidsCacheBean;

    @Bean
    RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory, MessageListenerAdapter listenerAdapter) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        List<String> patternTopic = this.reidsCacheBean.getPatternTopic();
        if (patternTopic == null || patternTopic.isEmpty()) {
            container.addMessageListener((MessageListener)listenerAdapter, (Topic)new PatternTopic("test"));
        } else {
            patternTopic.forEach(str -> container.addMessageListener((MessageListener)listenerAdapter, (Topic)new PatternTopic(str)));
        }
        return container;
    }

    @Bean
    MessageListenerAdapter listenerAdapter(RedisReceiver receiver) {
        LOG.info("\u9ed8\u8ba4\u6d88\u606f\u9002\u914d\u5668");
        return new MessageListenerAdapter((Object)receiver, "receiveMessage");
    }

    @Bean
    StringRedisTemplate template(RedisConnectionFactory connectionFactory) {
        return new StringRedisTemplate(connectionFactory);
    }
}

