package cn.jdevelops.constant.unit;


/**
 * 单位表
 *
 * @author tn
 * @date 2020-09-18 09:21
 */
public interface HjUnit {

    /**
     * 温度
     */
    String TEMPERATURE_UNIT = "℃";

    /**
     * 湿度
     */
    String HUMIDITY_UNIT = "%RH";

    /**
     * 风向角度
     */
    String WDIRECTANGLE_UNIT = "°";

    /**
     * 风速
     */
    String WSPEED_UNIT = "m/s";

    /**
     * 大气压
     */
    String APRESS_UNIT = "hPa";

    /**
     * VOC（挥发性有机化合物）体积浓度
     */
    String VOC_UNIT = "ppb";

    /**
     * VOC（挥发性有机化合物）质量浓度
     */
    String VOC2_UNIT = "mg/m³";

    /**
     * VOC告警标准值
     */
    String STANDARD_UNIT = "mg/m³";

    /**
     * CO2(二氧化碳浓度)
     */
    String CO2_UNIT = "ppm";

    /**
     * PM2.5(细颗粒物)
     */
    String PM2_5_UNIT = "μg/m³";

    /**
     * o2(氧气)
     */
    String O2_UNIT = "vol%";

    /**
     * TVOC(总挥发性有机化合物)
     */
    String TVOC_UNIT = "mg/m³";

    /**
     * 烟雾
     */
    String SMOG_UNIT = "ppm";

    /**
     * CH20(甲醛)
     */
    String CH20_UNIT = "ppm";

    /**
     * CO(一氧化碳)
     */
    String CO_UNIT = "ppm";

    /**
     * CH4(甲烷)
     */
    String CH4_UNIT = "%LEL";

    /**
     * PM10(可吸入颗粒物)
     */
    String PM10_UNIT = "μg/m³";

    /**
     * 功率因数
     */
    String PF_UNIT = "VA";

    /**
     * 有功功率
     */
    String P_UNIT = "KWh";

    /**
     * 无功功率
     */
    String Q_UNIT = "Kvarh";

    /**
     * 电压
     */
    String V_UNIT = "V";

    /**
     * 功率
     */
    String W_UNIT = "W";

    /**
     * 电流
     */
    String A_UNIT = "A";

    /**
     * 频率
     */
    String HZ_UNIT = "Hz";

}
