/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.api.sign.util;

import cn.jdevelops.api.result.util.SpringBeanUtils;
import cn.jdevelops.api.sign.config.ApiSignConfig;
import cn.jdevelops.util.encryption.core.SignMD5Util;
import cn.jdevelops.util.encryption.core.SignShaUtil;
import com.alibaba.fastjson2.JSON;
import java.util.ArrayList;
import java.util.Map;

public class SignUtil {
    public static String map2Str(Map<String, Object> map) {
        ArrayList<Map.Entry<String, Object>> list = new ArrayList<Map.Entry<String, Object>>(map.entrySet());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> mapping : list) {
            sb.append(mapping.getKey()).append("=").append(mapping.getValue()).append("&");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static <T extends Map> String getMd5SignByMap2Json(T maps) {
        String encrypt1 = SignMD5Util.encrypt((String)JSON.toJSONString(maps), (boolean)true);
        return SignUtil.getMd5Sign(encrypt1);
    }

    public static <T extends Map> String getMd5SignByMap2Str(T maps) {
        String encrypt1 = SignMD5Util.encrypt((String)SignUtil.map2Str(maps), (boolean)true);
        return SignUtil.getMd5Sign(encrypt1);
    }

    public static String getMd5SignByJson(String jsonStr) {
        String encrypt1 = SignMD5Util.encrypt((String)jsonStr, (boolean)true);
        return SignUtil.getMd5Sign(encrypt1);
    }

    public static String getMd5SignBymap2Str(String map2Str) {
        String encrypt1 = SignMD5Util.encrypt((String)map2Str, (boolean)true);
        return SignUtil.getMd5Sign(encrypt1);
    }

    private static String getMd5Sign(String encrypt1) {
        return SignMD5Util.encrypt((String)(encrypt1 + SignUtil.getSalt()), (boolean)true);
    }

    public static String getShaSign(String map2Str) {
        return SignShaUtil.encrypt((String)map2Str);
    }

    public static String getSalt() {
        ApiSignConfig apiSignBean = (ApiSignConfig)SpringBeanUtils.getInstance().getBean(ApiSignConfig.class);
        return apiSignBean.getSalt();
    }
}

