/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.api.sign.core;

import cn.jdevelops.api.result.custom.ExceptionResultWrap;
import cn.jdevelops.api.result.util.SpringBeanUtils;
import cn.jdevelops.api.sign.annotation.Signature;
import cn.jdevelops.api.sign.config.ApiSignConfig;
import cn.jdevelops.api.sign.enums.SginEnum;
import cn.jdevelops.api.sign.enums.SginExceptionCodeEnum;
import cn.jdevelops.api.sign.exception.SignException;
import cn.jdevelops.util.encryption.core.SignMD5Util;
import cn.jdevelops.util.encryption.core.SignShaUtil;
import cn.jdevelops.util.interceptor.api.ApiBeforeInterceptor;
import cn.jdevelops.util.interceptor.util.RequestUtil;
import cn.jdevelops.util.interceptor.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

@Component
@Order(value=2)
public class SignAppInterceptor
implements ApiBeforeInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(SignAppInterceptor.class);

    public boolean before(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler.getClass().isAssignableFrom(HandlerMethod.class)) {
            Signature signAnt = (Signature)((HandlerMethod)handler).getMethodAnnotation(Signature.class);
            ApiSignConfig apiSignBean = (ApiSignConfig)SpringBeanUtils.getInstance().getBean(ApiSignConfig.class);
            if (signAnt != null && !this.signCheck(request, signAnt.type(), apiSignBean.getSalt())) {
                response.setHeader("content-type", "application/json;charset=UTF-8");
                response.getOutputStream().write(JSON.toJSONString((Object)ExceptionResultWrap.result((Integer)SginExceptionCodeEnum.API_SIGN_ERROR.getCode(), (String)SginExceptionCodeEnum.API_SIGN_ERROR.getMessage())).getBytes("UTF-8"));
                return false;
            }
        }
        return true;
    }

    private boolean signCheck(HttpServletRequest request, SginEnum enums, String salt) {
        Object map = null;
        String paramsHeader = "";
        if (StrUtil.isNotBlank((CharSequence)SignAppInterceptor.getHeaderSign(request))) {
            paramsHeader = SignAppInterceptor.showParamsHeader(request);
        } else {
            map = SignAppInterceptor.showParams(request);
        }
        if (enums == SginEnum.MD5) {
            return SignMD5Util.check((Object)map, (String)salt);
        }
        if (enums == SginEnum.SHA) {
            return SignShaUtil.check((Object)map);
        }
        if (enums == SginEnum.MD5HEADER) {
            return SignMD5Util.checkHeader((HttpServletRequest)request, (String)paramsHeader, (String)salt);
        }
        return true;
    }

    public static String showParamsHeader(HttpServletRequest request) {
        try {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                String[] paramValues = request.getParameterValues(paramName);
                if (paramValues.length == 1) {
                    String paramValue = paramValues[0];
                    if (paramValue.length() == 0) continue;
                    map.put(paramName, paramValue);
                    continue;
                }
                map.put(paramName, paramValues);
            }
            if (map.isEmpty()) {
                String bodyString = JSON.parse((String)RequestUtil.getBodyString((ServletRequest)request)).toString();
                LOG.debug("\u52a0\u5bc6\u96c6\uff1a{}", (Object)bodyString);
                return bodyString;
            }
            String jsonString = JSON.toJSONString(map);
            LOG.debug("\u52a0\u5bc6\u96c6\uff1a{}", (Object)jsonString);
            return jsonString;
        }
        catch (Exception e) {
            throw new SignException("\u52a0\u5bc6\u53c2\u6570\u6709\u8bef", e);
        }
    }

    public static Object showParams(HttpServletRequest request) {
        try {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            Enumeration paramNames = request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String paramValue;
                String paramName = (String)paramNames.nextElement();
                String[] paramValues = request.getParameterValues(paramName);
                if (paramValues.length != 1 || (paramValue = paramValues[0]).length() == 0) continue;
                map.put(paramName, paramValue);
            }
            if (map.isEmpty()) {
                String bodyString = RequestUtil.getBodyString((ServletRequest)request);
                LinkedHashMap linkedHashMap = (LinkedHashMap)JSON.parseObject((String)bodyString, LinkedHashMap.class);
                LOG.debug("\u52a0\u5bc6\u96c6\uff1a{}", (Object)JSON.toJSONString((Object)linkedHashMap));
                return linkedHashMap;
            }
            LOG.debug("\u52a0\u5bc6\u96c6\uff1a{}", (Object)JSON.toJSONString(map));
            return map;
        }
        catch (Exception e) {
            throw new SignException("\u52a0\u5bc6\u53c2\u6570\u6709\u8bef", e);
        }
    }

    public static String getHeaderSign(HttpServletRequest request) {
        try {
            String signName = "sign";
            String sign = request.getHeader("sign");
            if (StrUtil.isNotBlank((CharSequence)sign)) {
                return sign;
            }
        }
        catch (Exception e) {
            LOG.warn("\u6d88\u606f\u5934\u4e2d\u6ca1\u6709sign");
        }
        return null;
    }
}

