/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.aop.exception.exception.aspect;

import cn.jdevelops.aop.exception.exception.AopException;
import cn.jdevelops.aop.exception.exception.annotation.DisposeException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;

@Aspect
@AutoConfiguration
public class ExceptionAspect {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionAspect.class);
    private static final int DEF_CODE = 500;
    private static Throwable oneEx;

    @Pointcut(value="@within(cn.jdevelops.aop.exception.exception.annotation.DisposeException) || @annotation(cn.jdevelops.aop.exception.exception.annotation.DisposeException)")
    public void disposeException() {
    }

    @AfterThrowing(value="disposeException()", throwing="ex")
    public void doAfterThrowing(JoinPoint jp, Exception ex) {
        MethodSignature signature = (MethodSignature)jp.getSignature();
        LOG.error("\u5904\u7406\u5f02\u5e38\u65f6\u6253\u5370\u539f\u59cb\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)ex);
        Method method = signature.getMethod();
        DisposeException disposeException = method.getAnnotation(DisposeException.class);
        if (Objects.isNull(disposeException)) {
            disposeException = jp.getTarget().getClass().getAnnotation(DisposeException.class);
        }
        String[] messages = disposeException.messages();
        Class[] exceptions = disposeException.exceptions();
        int[] codes = disposeException.codes();
        oneEx = ex;
        for (int i = 0; i < exceptions.length; ++i) {
            this.search(exceptions, codes, ex, messages, i);
        }
        throw new AopException(500, oneEx.getMessage());
    }

    protected void search(Class[] exceptions, int[] codes, Throwable ex, String[] messages, int index) {
        String eName;
        int code = 500;
        try {
            eName = ex.getClass().getName();
        }
        catch (Exception e) {
            return;
        }
        Class exception = exceptions[index];
        String pName = exception.getName();
        if (eName.equalsIgnoreCase(pName)) {
            String message = ex.getMessage();
            try {
                message = messages[index];
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                code = codes[index];
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw new AopException(code, message);
        }
        this.search(exceptions, codes, ex.getCause(), messages, index);
    }
}

