/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.aop.api.log.aspect;

import cn.jdevelops.aop.api.log.annotation.ApiLog;
import cn.jdevelops.aop.api.log.bean.ApiMonitoring;
import cn.jdevelops.aop.api.log.server.ApiLogSave;
import cn.jdevelops.util.aops.AopReasolver;
import cn.jdevelops.util.aops.IpUtil;
import cn.jdevelops.util.aops.JsonUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class ApiLogAspectSave {
    private static final Logger LOG = LoggerFactory.getLogger((String)"APILOG");
    @Autowired
    private ApiLogSave apiLogSave;
    String expressionError = "";

    @Pointcut(value="@annotation(cn.jdevelops.aop.api.log.annotation.ApiLog)")
    public void apiLog() {
    }

    @AfterThrowing(value="apiLog()", throwing="ex")
    public void doAfterThrowing(JoinPoint jp, Exception ex) {
        ApiMonitoring apiLog = new ApiMonitoring();
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = signature.getMethod();
        ApiLog myLog = method.getAnnotation(ApiLog.class);
        if (myLog != null) {
            apiLog.setDescription(myLog.expression());
            apiLog.setChineseApi(myLog.chineseApi());
            apiLog.setLogType(myLog.type().getType());
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        String requestUri = request.getRequestURI();
        apiLog.setApiUrl(requestUri);
        apiLog.setCallType(2);
        apiLog.setMethod(request.getMethod());
        apiLog.setStatus(false);
        apiLog.setOutParams("\u63a5\u53e3\u8c03\u7528\u51fa\u9519");
        apiLog.setCallTime(System.currentTimeMillis());
        apiLog.setInParams("");
        apiLog.setExpression(this.expressionError);
        apiLog.setPoxyIp(IpUtil.getPoxyIp((HttpServletRequest)request));
        this.apiLogSave.saveLog(apiLog);
    }

    @AfterReturning(value="apiLog()", returning="rvt")
    public void saveSysLog(JoinPoint joinPoint, Object rvt) {
        ApiLog myLog;
        HttpServletRequest request;
        ApiMonitoring apiLog;
        block17: {
            apiLog = new ApiMonitoring();
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            request = requestAttributes.getRequest();
            String requestUri = request.getRequestURI();
            apiLog.setApiUrl(requestUri);
            apiLog.setMethod(request.getMethod());
            apiLog.setCallType(1);
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            myLog = method.getAnnotation(ApiLog.class);
            if (myLog == null || !myLog.enable()) {
                return;
            }
            Object expression = AopReasolver.newInstance().resolver(joinPoint, myLog.expression());
            if (null != expression) {
                this.expressionError = expression.toString();
                apiLog.setExpression(this.expressionError);
            } else {
                apiLog.setExpression("");
            }
            apiLog.setDescription(myLog.description());
            apiLog.setChineseApi(myLog.chineseApi());
            apiLog.setLogType(myLog.type().getType());
            if (Objects.nonNull(rvt)) {
                try {
                    if (myLog.logResultData()) {
                        if (rvt instanceof String || rvt instanceof Integer) {
                            apiLog.setStatus(true);
                        } else if (rvt instanceof List) {
                            apiLog.setStatus(true);
                        } else {
                            Map<String, Object> beanToMap = ApiLogAspectSave.beanToMap(rvt);
                            if (beanToMap.get("code").equals(200)) {
                                apiLog.setStatus(true);
                            } else {
                                apiLog.setStatus(true);
                            }
                        }
                        apiLog.setOutParams(JsonUtils.toJson((Object)rvt));
                        break block17;
                    }
                    apiLog.setStatus(true);
                    apiLog.setOutParams("");
                }
                catch (Exception e) {
                    LOG.error("\u89e3\u6790\u7ed3\u679c\u5931\u8d25", (Throwable)e);
                    apiLog.setStatus(false);
                    apiLog.setOutParams("");
                }
            } else {
                apiLog.setStatus(true);
                apiLog.setOutParams("");
            }
        }
        apiLog.setCallTime(System.currentTimeMillis());
        if (myLog.logArgs()) {
            Object[] args = joinPoint.getArgs();
            try {
                List argObjects = Arrays.stream(args).filter(s -> !(s instanceof HttpServletRequest) && !(s instanceof HttpServletResponse)).collect(Collectors.toList());
                String params = JsonUtils.toJson(argObjects);
                apiLog.setInParams(params.contains("null") ? params.replaceAll("null", "") : params);
            }
            catch (Exception e) {
                LOG.error("\u89e3\u6790\u5165\u53c2\u5931\u8d25", (Throwable)e);
                apiLog.setInParams("");
            }
        }
        apiLog.setPoxyIp(IpUtil.getPoxyIp((HttpServletRequest)request));
        this.apiLogSave.saveLog(apiLog);
    }

    private static Map<String, Object> beanToMap(Object bean) {
        if (bean == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(50);
        try {
            Method[] methods;
            Class<?> c = bean.getClass();
            for (Method method : methods = c.getMethods()) {
                Object value;
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = name.substring(3);
                }
                if (key.isEmpty() || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                if ("class".equalsIgnoreCase(key) || (value = method.invoke(bean, new Object[0])) == null) continue;
                hashMap.put(key, value);
            }
        }
        catch (Throwable var9) {
            var9.printStackTrace();
        }
        return hashMap;
    }
}

