/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.doc.swagger.cloud.core;

import cn.jdevelops.doc.core.swagger.bean.SwaggerBean;
import cn.jdevelops.doc.core.swagger.config.BaseConfig;
import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import java.net.InetAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.annotation.Value;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.oas.annotations.EnableOpenApi;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spring.web.plugins.Docket;

@EnableOpenApi
@EnableKnife4j
@Configurable
public class SwaggerConfig {
    public static final String SPIRIT = "/";
    @Value(value="${server.servlet.context-path:/}")
    private String serverName;
    @Value(value="${server.port:8080}")
    private String serverPort;
    @Autowired(required=false)
    private SwaggerBean swaggerBean;

    public Docket createRestApi() {
        Docket build = new Docket(this.swaggerBean.getDocket()).enable(this.swaggerBean.getShow().booleanValue()).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerBean.getBasePackage())).paths(PathSelectors.any()).build();
        if (Boolean.TRUE.equals(this.swaggerBean.getAddHeaderToken())) {
            return build.securitySchemes(BaseConfig.security()).securityContexts(BaseConfig.securityContexts());
        }
        return build;
    }

    private ApiInfo apiInfo() {
        Contact contact = new Contact(this.swaggerBean.getContactName(), this.swaggerBean.getContactUrl(), this.swaggerBean.getContactEmail());
        String address = "127.0.0.1";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            address = inetAddress.getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (SPIRIT.equals(this.serverName)) {
            this.serverName = "";
        }
        return new ApiInfoBuilder().title(this.swaggerBean.getTitle()).description(this.swaggerBean.getDescription()).contact(contact).version(this.swaggerBean.getVersion()).termsOfServiceUrl("http://" + address + ":" + this.serverPort + this.serverName).build();
    }
}

