/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.mybatis.server.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;

public class ObjectUtil {
    private static Boolean needFilterField(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            return true;
        }
        return Modifier.isTransient(field.getModifiers());
    }

    public static Map<String, Object> getFieldList(Object obj) throws IllegalAccessException {
        Field[] fields;
        LinkedHashMap<String, Object> fieldMap = new LinkedHashMap<String, Object>();
        Class<?> clazz = obj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (Boolean.TRUE.equals(ObjectUtil.needFilterField(field))) continue;
            field.setAccessible(true);
            Object value = field.get(obj);
            if (value == null) continue;
            fieldMap.put(field.getName(), value);
        }
        ObjectUtil.getParentField(clazz, fieldMap, obj);
        return fieldMap;
    }

    private static void getParentField(Class<?> clazz, Map<String, Object> fieldMap, Object obj) throws IllegalAccessException {
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            Field[] superFields;
            for (Field field : superFields = superClazz.getDeclaredFields()) {
                if (Boolean.TRUE.equals(ObjectUtil.needFilterField(field))) continue;
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value == null) continue;
                fieldMap.put(field.getName(), value);
            }
            ObjectUtil.getParentField(superClazz, fieldMap, obj);
        }
    }

    public static Map<String, Method> getMethodMap(Object obj) {
        Method[] methods;
        LinkedHashMap<String, Method> methodMap = new LinkedHashMap<String, Method>();
        Class<?> clazz = obj.getClass();
        for (Method method : methods = clazz.getMethods()) {
            methodMap.put(method.getName(), method);
        }
        ObjectUtil.getParentMethod(clazz, methodMap);
        return methodMap;
    }

    private static void getParentMethod(Class<?> clazz, Map<String, Method> methodMap) {
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            Method[] superMethods;
            for (Method field : superMethods = superClazz.getMethods()) {
                methodMap.put(field.getName(), field);
            }
            ObjectUtil.getParentMethod(superClazz, methodMap);
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        try {
            Map<String, Method> methodMap = ObjectUtil.getMethodMap(obj);
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = methodMap.get(getter);
            Object value = null;
            if (method != null) {
                value = method.invoke(obj, new Object[0]);
            }
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }
}

