/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.mybatis.server.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CamlCaseUtil {
    public static String toCamlCase(String line, boolean smallCamel) {
        if (line == null || "".equals(line)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Pattern pattern = Pattern.compile("([A-Za-z\\d]+)(_)?");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            String word = matcher.group();
            sb.append(smallCamel && matcher.start() == 0 ? Character.toLowerCase(word.charAt(0)) : Character.toUpperCase(word.charAt(0)));
            int index = word.lastIndexOf(95);
            if (index > 0) {
                sb.append(word.substring(1, index).toLowerCase());
                continue;
            }
            sb.append(word.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static String toLine(String str) {
        Pattern humpPattern = Pattern.compile("[A-Z]");
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        String string = sb.toString();
        if (str.substring(0, 1).toCharArray()[0] >= 'A' && str.substring(0, 1).toCharArray()[0] <= 'Z') {
            string = string.substring(1);
        }
        return string;
    }

    public static String replaceAll(String str, String replacement) {
        String regEx = "[\n`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(replacement).trim();
    }
}

