/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.mybatis.server.controller;

import cn.jdevelops.entity.basics.vo.SerializableVO;
import cn.jdevelops.mybatis.server.util.ObjectUtil;
import cn.jdevelops.mybatis.server.util.WrapperUtils;
import cn.jdevelops.result.page.ResourcePage;
import cn.jdevelops.result.response.PageVO;
import cn.jdevelops.result.response.SortVO;
import cn.jdevelops.result.result.ResultVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseController<M extends IService<T>, T extends SerializableVO<T>, S extends SerializableVO<S>, U extends SerializableVO<U>, R extends SerializableVO<R>> {
    @Autowired
    private M service;
    private static final int T_INDEX = 1;
    private static final int R_INDEX = 4;
    private Class<T> tClass;
    private Class<R> rClass;

    protected BaseController() {
        Type type = this.getClass().getGenericSuperclass();
        Type trueType1 = ((ParameterizedType)type).getActualTypeArguments()[1];
        this.tClass = (Class)trueType1;
        Type trueType2 = ((ParameterizedType)type).getActualTypeArguments()[4];
        this.rClass = (Class)trueType2;
    }

    @PostMapping(value={"saveOrUpdate"})
    @ApiOperation(value="\u5355\u4e2a\u4fdd\u5b58\u6216\u66f4\u65b0")
    public ResultVO<R> saveOrUpdate(@RequestBody U u) {
        SerializableVO t = (SerializableVO)SerializableVO.to(u, this.tClass);
        this.service.saveOrUpdate((Object)t);
        return ResultVO.success((Object)SerializableVO.to((Object)t, this.rClass), (String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u6216\u66f4\u65b0")
    @PostMapping(value={"/batchSaveOrUpdate"})
    public ResultVO<String> batchSaveOrUpdate(@RequestBody List<U> list) {
        return ResultVO.resultMsg((boolean)this.service.saveOrUpdateBatch((Collection)SerializableVO.to(list, this.tClass)), (String)"\u6279\u91cf\u64cd\u4f5c");
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    @DeleteMapping(value={"delete"})
    public ResultVO<String> delete(@RequestParam(value="id") Long id) {
        return ResultVO.resultMsg((boolean)this.service.removeById((Serializable)id), (String)"\u5220\u9664");
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2")
    @GetMapping(value={"/getById"})
    public ResultVO<R> getById(@RequestParam(value="id") Long id) {
        this.service.getById((Serializable)id);
        return ResultVO.resultDataMsgForT((boolean)true, (Object)SerializableVO.to((Object)this.service.getById((Serializable)id), this.rClass), (String)"\u67e5\u8be2");
    }

    @ApiOperation(value="\u6839\u636euuid\u67e5\u8be2")
    @GetMapping(value={"/uuid"})
    public ResultVO<R> getById(@RequestParam(value="uuid") Object uuid) {
        SerializableVO t = (SerializableVO)this.service.getOne((Wrapper)new QueryWrapper().eq((Object)"uuid", uuid));
        return ResultVO.resultDataMsgForT((boolean)true, (Object)SerializableVO.to((Object)t, this.rClass), (String)"\u67e5\u8be2");
    }

    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8")
    @PostMapping(value={"/list"})
    public ResultVO<List<R>> getList(@RequestBody S s) {
        SerializableVO t = (SerializableVO)SerializableVO.to(s, this.tClass);
        QueryWrapper<SerializableVO> wrapper = WrapperUtils.createWrapper(t);
        SortVO sortVO = (SortVO)ObjectUtil.getFieldValue(s, "sortVO");
        if (sortVO != null) {
            wrapper = WrapperUtils.createOrderBy(wrapper, sortVO);
        }
        List list = this.service.list(wrapper);
        List list1 = SerializableVO.to((Collection)list, this.rClass);
        return ResultVO.resultDataMsgForT((boolean)true, (Object)list1, (String)"\u67e5\u8be2\u5168\u90e8");
    }

    @ApiOperation(value="\u6761\u4ef6\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/queryPage"})
    public ResultVO<ResourcePage<List<R>>> queryPage(@RequestBody S s) {
        PageVO pageVO = (PageVO)ObjectUtil.getFieldValue(s, "pageVO");
        SortVO sortVO = (SortVO)ObjectUtil.getFieldValue(s, "sortVO");
        assert (pageVO != null);
        Page pageParam = new Page((long)pageVO.getPageIndex().intValue(), (long)pageVO.getPageSize().intValue());
        SerializableVO t = (SerializableVO)SerializableVO.to(s, this.tClass);
        QueryWrapper<SerializableVO> wrapper = WrapperUtils.createWrapper(t);
        if (sortVO != null) {
            wrapper = WrapperUtils.createOrderBy(wrapper, sortVO);
        }
        Page page = (Page)this.service.page((IPage)pageParam, wrapper);
        long total = page.getTotal();
        List records = page.getRecords();
        List list = SerializableVO.to((Collection)records, this.rClass);
        ResourcePage resultPage = ResourcePage.page((Long)total, (Object)list);
        return ResultVO.success((Object)resultPage, (String)"\u67e5\u8be2\u6210\u529f");
    }
}

