/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.mybatis.server.util;

import cn.jdevelops.mybatis.server.util.CamlCaseUtil;
import cn.jdevelops.mybatis.server.util.ObjectUtil;
import cn.jdevelops.mybatis.server.vo.QueryVo;
import cn.jdevelops.result.response.SortVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WrapperUtils {
    public static <T> QueryWrapper<T> createWrapper(T t) {
        try {
            Map<String, Object> fieldList = ObjectUtil.getFieldList(t);
            HashMap params = new HashMap(16);
            QueryWrapper queryWrapper = new QueryWrapper();
            fieldList.forEach((key, value) -> {
                if (value != null && StringUtils.isNotBlank((CharSequence)value.toString())) {
                    params.put(CamlCaseUtil.toLine(key), value);
                }
            });
            if (!params.isEmpty()) {
                queryWrapper = (QueryWrapper)queryWrapper.allEq(params);
            }
            return queryWrapper;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> QueryWrapper<T> createOrderBy(QueryWrapper<T> wrapper, SortVO sortVO) {
        if (sortVO != null) {
            boolean flag = sortVO.getOrderDesc() == null || sortVO.getOrderDesc() != 1;
            wrapper = (QueryWrapper)wrapper.orderBy(StringUtils.isNotBlank((CharSequence)sortVO.getOrderBy()), flag, (Object)sortVO.getOrderBy());
        }
        return wrapper;
    }

    public static <T> QueryWrapper<T> createWrapper(List<QueryVo> queryVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        for (QueryVo vo : queryVo) {
            switch (vo.getType()) {
                case "eq": {
                    queryWrapper.eq((Object)vo.getKey(), (Object)vo.getValue());
                    break;
                }
                case "ne": {
                    queryWrapper.ne((Object)vo.getKey(), (Object)vo.getValue());
                    break;
                }
                case "like": {
                    queryWrapper.like((Object)vo.getKey(), (Object)vo.getValue());
                    break;
                }
                case "leftlike": {
                    queryWrapper.likeLeft((Object)vo.getKey(), (Object)vo.getValue());
                    break;
                }
                case "rightlike": {
                    queryWrapper.likeRight((Object)vo.getKey(), (Object)vo.getValue());
                    break;
                }
                case "notlike": {
                    queryWrapper.notLike((Object)vo.getKey(), (Object)vo.getValue());
                    break;
                }
                case "gt": {
                    queryWrapper.gt((Object)vo.getKey(), (Object)vo.getValue());
                    break;
                }
                case "lt": {
                    queryWrapper.lt((Object)vo.getKey(), (Object)vo.getValue());
                    break;
                }
                case "ge": {
                    queryWrapper.ge((Object)vo.getKey(), (Object)vo.getValue());
                    break;
                }
                case "le": {
                    queryWrapper.le((Object)vo.getKey(), (Object)vo.getValue());
                    break;
                }
            }
        }
        return queryWrapper;
    }
}

