/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.exception.handler;

import cn.jdevelops.enums.result.ResultCodeEnum;
import cn.jdevelops.exception.exception.BusinessException;
import cn.jdevelops.exception.result.ExceptionResultWrap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class ControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerExceptionHandler.class);
    @Resource
    private HttpServletResponse response;
    private static final String JSON_ERROR_INFO = "JSON parse error:";
    private static final String SEMICOLON = ";";
    private static final char BLANK = ' ';
    private static final int CUT_LENGTH = 100;

    @ExceptionHandler(value={BusinessException.class})
    public Object handleBusinessException(BusinessException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        return ExceptionResultWrap.error(e.getCode(), e.getErrorMessage(), null);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Object exceptionHandler(NoHandlerFoundException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        return ExceptionResultWrap.error(ResultCodeEnum.AUTH_ERROR.getCode(), "\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\u662f\u5426\u6b63\u786e");
    }

    @ExceptionHandler(value={NullPointerException.class})
    public Object handleNullPointerException(NullPointerException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        return ExceptionResultWrap.error(ResultCodeEnum.SYS_ERROR.getCode(), "\u6682\u65f6\u65e0\u6cd5\u83b7\u53d6\u6570\u636e");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Object handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        return ExceptionResultWrap.error(ResultCodeEnum.AUTH_ERROR.getCode(), "\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u5bf9 - get post ");
    }

    @ExceptionHandler
    public Object exceptionHandler(HttpMessageNotReadableException e) {
        String jsonErrorMsg;
        log.error(e.getMessage(), (Throwable)e);
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        if (e.getLocalizedMessage().contains(JSON_ERROR_INFO) && Objects.nonNull(jsonErrorMsg = this.dealWithJsonExceptionError(e.getLocalizedMessage()))) {
            return ExceptionResultWrap.error(ResultCodeEnum.JSON_ERROR.getCode(), "\u683c\u5f0f\u8f6c\u6362\u9519\u8bef,\u8bf7\u68c0\u67e5" + jsonErrorMsg + "\u5b57\u6bb5");
        }
        return ExceptionResultWrap.error(ResultCodeEnum.MESSAGE_NO_READING.getCode(), "\u6d88\u606f\u4e0d\u53ef\u8bfb\uff1a" + StringUtils.substring((String)e.getMessage(), (int)0, (int)100));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Object exception(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        BindingResult bindingResult = e.getBindingResult();
        List allErrors = bindingResult.getAllErrors();
        StringBuilder sb = new StringBuilder();
        allErrors.forEach(objectError -> {
            FieldError fieldError = (FieldError)objectError;
            sb.append(SEMICOLON).append(fieldError.getField()).append(":").append(fieldError.getDefaultMessage());
        });
        String message = sb.length() > 0 ? sb.substring(1) : sb.toString();
        return ExceptionResultWrap.error(ResultCodeEnum.CHECK_ERROR.getCode(), message);
    }

    @ExceptionHandler(value={Exception.class})
    public Object handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        return ExceptionResultWrap.error(ResultCodeEnum.SYS_ERROR.getCode(), "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @ExceptionHandler(value={BindException.class})
    public Object bindException(BindException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        StringBuilder resqStr = new StringBuilder();
        e.getFieldErrors().forEach(it -> {
            resqStr.append("\u5b57\u6bb5:").append(it.getField()).append(" ==\u300b \u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0\u662f\uff1a").append(it.getDefaultMessage());
            resqStr.append("\u3002  ");
        });
        return ExceptionResultWrap.error(ResultCodeEnum.SYS_ERROR.getCode(), resqStr.toString());
    }

    private String dealWithJsonExceptionError(String errorMsg) {
        int lastSemicolon = errorMsg.lastIndexOf(SEMICOLON);
        if (lastSemicolon != -1) {
            int startIndex;
            for (startIndex = lastSemicolon - 1; startIndex > 0 && errorMsg.charAt(startIndex) != ' '; --startIndex) {
            }
            return errorMsg.substring(++startIndex, lastSemicolon);
        }
        return null;
    }
}

