/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.exception.handler;

import cn.jdevelops.enums.result.ResultCodeEnum;
import cn.jdevelops.exception.exception.BusinessException;
import cn.jdevelops.result.result.ResultVO;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class ControllerExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ControllerExceptionHandler.class);
    @Resource
    private HttpServletResponse response;
    private static final String JSON_ERROR_INFO = "JSON parse error:";
    private static final String SEMICOLON = ";";
    private static final char BLANK = ' ';
    private static final int CUT_LENGTH = 100;

    @ExceptionHandler(value={BusinessException.class})
    public ResultVO<?> handleBusinessException(BusinessException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        return ResultVO.fail((int)e.getCode(), (String)e.getErrorMessage());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResultVO<?> exceptionHandler(NoHandlerFoundException e) {
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        log.error("\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\u662f\u5426\u6b63\u786e -> ", (Throwable)e);
        return ResultVO.fail((int)ResultCodeEnum.AuthError.getCode(), (String)"\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\u662f\u5426\u6b63\u786e");
    }

    @ExceptionHandler(value={NullPointerException.class})
    public ResultVO<?> handleNullPointerException(NullPointerException e) {
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        log.error("\u7a7a\u6307\u9488\u5f02\u5e38 -> ", (Throwable)e);
        return ResultVO.fail((int)ResultCodeEnum.SysError.getCode(), (String)"\u6682\u65f6\u65e0\u6cd5\u83b7\u53d6\u6570\u636e");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResultVO<?> handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        log.error("\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u5bf9 - get post -> ", (Throwable)e);
        return ResultVO.fail((int)ResultCodeEnum.AuthError.getCode(), (String)"\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u5bf9 - get post ");
    }

    @ExceptionHandler
    public ResultVO<?> exceptionHandler(HttpMessageNotReadableException e) {
        String jsonErrorMsg;
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        log.error("[Handle_HttpMessageNotReadableException] - {}", (Throwable)e);
        if (e.getLocalizedMessage().contains(JSON_ERROR_INFO) && Objects.nonNull(jsonErrorMsg = this.dealWithJsonExceptionError(e.getLocalizedMessage()))) {
            return ResultVO.fail((int)ResultCodeEnum.JsonError.getCode(), (String)("\u683c\u5f0f\u8f6c\u6362\u9519\u8bef,\u8bf7\u68c0\u67e5" + jsonErrorMsg + "\u5b57\u6bb5"));
        }
        return ResultVO.fail((int)ResultCodeEnum.MessageNoReading.getCode(), (String)("\u6d88\u606f\u4e0d\u53ef\u8bfb\uff1a" + StringUtils.substring((String)e.getMessage(), (int)0, (int)100)));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultVO<?> exception(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), (Throwable)e);
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        BindingResult bindingResult = e.getBindingResult();
        List allErrors = bindingResult.getAllErrors();
        StringBuilder sb = new StringBuilder();
        allErrors.forEach(objectError -> {
            FieldError fieldError = (FieldError)objectError;
            sb.append(SEMICOLON).append(fieldError.getField()).append(":").append(fieldError.getDefaultMessage());
        });
        String message = sb.length() > 0 ? sb.substring(1) : sb.toString();
        return ResultVO.fail((int)ResultCodeEnum.CheckError.getCode(), (String)message);
    }

    @ExceptionHandler(value={Exception.class})
    public ResultVO<?> handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        return ResultVO.fail((int)ResultCodeEnum.SysError.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public ResultVO<?> bindException(BindException e) {
        this.response.setHeader("content-type", "application/json;charset=UTF-8");
        log.error("Valid \u6570\u636e\u683c\u5f0f\u6821\u9a8c\u5f02\u5e38 -> ", (Throwable)e);
        StringBuilder resqStr = new StringBuilder();
        e.getFieldErrors().forEach(it -> {
            resqStr.append("\u5b57\u6bb5:" + it.getField() + " ==\u300b \u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0\u662f\uff1a" + it.getDefaultMessage());
            resqStr.append("\u3002  ");
        });
        return ResultVO.fail((int)ResultCodeEnum.SysError.getCode(), (String)resqStr.toString());
    }

    private String dealWithJsonExceptionError(String errorMsg) {
        int lastSemicolon = errorMsg.lastIndexOf(SEMICOLON);
        if (lastSemicolon != -1) {
            int startIndex;
            for (startIndex = lastSemicolon - 1; startIndex > 0 && errorMsg.charAt(startIndex) != ' '; --startIndex) {
            }
            return errorMsg.substring(++startIndex, lastSemicolon);
        }
        return null;
    }
}

