/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.version.config;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.condition.RequestCondition;

public class ApiVersionCondition
implements RequestCondition<ApiVersionCondition> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiVersionCondition.class);
    private double apiVersion;

    public ApiVersionCondition(double apiVersion) {
        this.apiVersion = apiVersion;
    }

    public double getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(double apiVersion) {
        this.apiVersion = apiVersion;
    }

    public ApiVersionCondition combine(ApiVersionCondition other) {
        return new ApiVersionCondition(other.getApiVersion());
    }

    public ApiVersionCondition getMatchingCondition(HttpServletRequest httpServletRequest) {
        try {
            double version;
            String reqVersion = httpServletRequest.getParameter("version");
            reqVersion = Optional.ofNullable(reqVersion).orElse(httpServletRequest.getHeader("version"));
            reqVersion = Optional.ofNullable(reqVersion).orElse("1.0");
            if (StringUtils.isNotBlank((CharSequence)reqVersion) && (version = Double.parseDouble(reqVersion)) >= this.apiVersion) {
                return this;
            }
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u7248\u672c\u53f7\u5931\u8d25", (Throwable)e);
            return this;
        }
        return null;
    }

    public int compareTo(ApiVersionCondition apiVersionCondition, HttpServletRequest httpServletRequest) {
        return Double.compare(apiVersionCondition.getApiVersion(), this.apiVersion);
    }
}

