/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.apilog.aspect;

import cn.jdevelops.aops.AopReasolver;
import cn.jdevelops.aops.IpUtil;
import cn.jdevelops.aops.JsonUtils;
import cn.jdevelops.apilog.annotation.ApiLog;
import cn.jdevelops.apilog.bean.ApiMonitoring;
import cn.jdevelops.apilog.server.ApiLogSave;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class ApiLogAspectSave {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiLogAspectSave.class);
    @Autowired
    private ApiLogSave apiLogSave;
    String appKeyError = "";

    @Pointcut(value="@annotation(cn.jdevelops.apilog.annotation.ApiLog)")
    public void apiLog() {
    }

    @AfterThrowing(value="apiLog()", throwing="ex")
    public void doAfterThrowing(JoinPoint jp, Exception ex) {
        ApiMonitoring apiLog = new ApiMonitoring();
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = signature.getMethod();
        ApiLog myLog = method.getAnnotation(ApiLog.class);
        if (myLog != null) {
            Object apiKey = AopReasolver.newInstance().resolver(jp, myLog.apiKey());
            apiLog.setApiKey(apiKey + "");
            apiLog.setChineseApi(myLog.chineseApi());
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        String requestUri = request.getRequestURI();
        apiLog.setApiName(requestUri);
        apiLog.setStatus("false");
        apiLog.setOutParams("\u63a5\u53e3\u8c03\u7528\u51fa\u9519");
        apiLog.setCallTime(DateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
        apiLog.setInParams("");
        apiLog.setPoxyIp(IpUtil.getPoxyIp((HttpServletRequest)request));
        this.apiLogSave.saveLog(apiLog);
    }

    @AfterReturning(value="apiLog()", returning="rvt")
    public void saveSysLog(JoinPoint joinPoint, Object rvt) {
        MethodSignature signature;
        Method method;
        ApiLog myLog;
        ApiMonitoring apiLog = new ApiMonitoring();
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        String requestUri = request.getRequestURI();
        apiLog.setApiName(requestUri);
        if (Objects.nonNull(rvt)) {
            try {
                if (rvt instanceof String || rvt instanceof Integer) {
                    apiLog.setStatus("true");
                } else if (rvt instanceof List) {
                    apiLog.setStatus("true");
                } else {
                    Map<String, Object> beanToMap = ApiLogAspectSave.beanToMap(rvt);
                    if (beanToMap.get("code").equals(200)) {
                        apiLog.setStatus("true");
                    } else {
                        apiLog.setStatus("false");
                    }
                }
                apiLog.setOutParams(JsonUtils.toJson((Object)rvt));
            }
            catch (Exception e) {
                apiLog.setStatus("false");
                apiLog.setOutParams("");
            }
        }
        if ((myLog = (method = (signature = (MethodSignature)joinPoint.getSignature()).getMethod()).getAnnotation(ApiLog.class)) != null) {
            Object apiKey = AopReasolver.newInstance().resolver(joinPoint, myLog.apiKey());
            this.appKeyError = Objects.nonNull(rvt) ? apiKey + "" : "";
            apiLog.setApiKey(this.appKeyError);
            apiLog.setChineseApi(myLog.chineseApi());
        }
        apiLog.setCallTime(DateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
        Object[] args = joinPoint.getArgs();
        try {
            List argObjects = Arrays.stream(args).filter(s -> !(s instanceof HttpServletRequest) && !(s instanceof HttpServletResponse)).collect(Collectors.toList());
            String params = JsonUtils.toJson(argObjects);
            apiLog.setInParams(params.contains("null") ? params.replaceAll("null", "") : params);
        }
        catch (Exception e) {
            apiLog.setInParams("");
        }
        apiLog.setPoxyIp(IpUtil.getPoxyIp((HttpServletRequest)request));
        this.apiLogSave.saveLog(apiLog);
    }

    private static Map<String, Object> beanToMap(Object bean) {
        if (bean == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(50);
        try {
            Method[] methods;
            Class<?> c = bean.getClass();
            for (Method method : methods = c.getMethods()) {
                Object value;
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = name.substring(3);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                if ("class".equalsIgnoreCase(key) || (value = method.invoke(bean, new Object[0])) == null) continue;
                hashMap.put(key, value);
            }
        }
        catch (Throwable var9) {
            var9.printStackTrace();
        }
        return hashMap;
    }
}

