/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.apilog.aspect;

import cn.jdevelops.apilog.annotation.ApiLog;
import cn.jdevelops.spring.core.aop.ParamsDis;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
public class ApiLogAspectSee {
    @Around(value="execution(* *.*..controller..*(..))")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        try {
            Signature signature = pjp.getSignature();
            MethodSignature methodSignature = (MethodSignature)signature;
            Method targetMethod = methodSignature.getMethod();
            Method realMethod = pjp.getTarget().getClass().getDeclaredMethod(signature.getName(), targetMethod.getParameterTypes());
            if (realMethod.isAnnotationPresent(ApiLog.class)) {
                return pjp.proceed();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HttpServletRequest request = ApiLogAspectSee.getRequest();
        if (Objects.isNull(request)) {
            return pjp.proceed();
        }
        return ParamsDis.aopDis((HttpServletRequest)request, (ProceedingJoinPoint)pjp);
    }

    private static HttpServletRequest getRequest() {
        try {
            RequestAttributes ra = RequestContextHolder.getRequestAttributes();
            ServletRequestAttributes sra = (ServletRequestAttributes)ra;
            assert (sra != null);
            return sra.getRequest();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

