/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.apilog.aspect;

import cn.jdevelops.apilog.annotation.ApiLog;
import cn.jdevelops.apilog.bean.ApiMonitoring;
import cn.jdevelops.apilog.server.ApiLogSave;
import cn.jdevelops.enums.string.StringEnum;
import cn.jdevelops.enums.time.TimeFormatEnum;
import cn.jdevelops.http.core.IpUtil;
import cn.jdevelops.spring.core.aop.AopReasolver;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class ApiLogAspectSave {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiLogAspectSave.class);
    @Autowired
    private ApiLogSave apiLogSave;
    String appKeyError = "";

    @Pointcut(value="@annotation(cn.jdevelops.apilog.annotation.ApiLog)")
    public void apiLog() {
    }

    @AfterReturning(value="apiLog()", returning="rvt")
    public void saveSysLog(JoinPoint joinPoint, Object rvt) {
        MethodSignature signature;
        Method method;
        ApiLog myLog;
        ApiMonitoring apiLog = new ApiMonitoring();
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        String requestUri = request.getRequestURI();
        apiLog.setApiName(requestUri);
        if (ObjectUtils.allNotNull((Object[])new Object[]{rvt})) {
            try {
                if (rvt instanceof String || rvt instanceof Integer) {
                    apiLog.setStatus("true");
                } else if (rvt instanceof List) {
                    apiLog.setStatus("true");
                } else {
                    Map<String, Object> beanToMap = this.beanToMap(rvt);
                    apiLog.setStatus(beanToMap.get("success") + "");
                }
                apiLog.setOutParams(JSONObject.toJSONString((Object)rvt));
            }
            catch (Exception e) {
                apiLog.setStatus("false");
                apiLog.setOutParams("");
            }
        }
        if ((myLog = (method = (signature = (MethodSignature)joinPoint.getSignature()).getMethod()).getAnnotation(ApiLog.class)) != null) {
            Object apiKey = AopReasolver.newInstance().resolver(joinPoint, myLog.apiKey());
            this.appKeyError = ObjectUtils.allNotNull((Object[])new Object[]{rvt}) ? apiKey + "" : "";
            apiLog.setApiKey(ObjectUtils.allNotNull((Object[])new Object[]{rvt}) ? apiKey + "" : "");
        }
        apiLog.setCallTime(DateTime.now().toString(TimeFormatEnum.DEFAULT_FORMAT_DATETIME.getFormat()));
        Object[] args = joinPoint.getArgs();
        try {
            String params = JSON.toJSONString((Object)args);
            apiLog.setInParams(params.contains("null") ? params.replaceAll("null", "") : params);
        }
        catch (Exception e) {
            apiLog.setInParams(null);
        }
        apiLog.setPoxyIp(IpUtil.getPoxyIp((HttpServletRequest)request));
        this.apiLogSave.saveLog(apiLog);
    }

    @AfterThrowing(value="apiLog()")
    public void doAfterThrowing() {
    }

    private Map<String, Object> beanToMap(Object obj) {
        Map<String, Object> params = new HashMap<String, Object>(15);
        try {
            PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
            PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors(obj);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if ("class".equals(name)) continue;
                params.put(name, propertyUtilsBean.getNestedProperty(obj, name));
            }
            if (obj != null && params.containsKey(StringEnum.EMPTY_STRING.getStr())) {
                params = (Map)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }
}

