package cn.jdevelops.apilog.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import cn.jdevelops.apilog.annotation.ApiLog;
import cn.jdevelops.apilog.bean.ApiMonitoring;
import cn.jdevelops.apilog.server.ApiLogSave;
import cn.jdevelops.enums.string.StringEnum;
import cn.jdevelops.enums.time.TimeFormatEnum;
import cn.jdevelops.http.core.IpUtil;
import cn.jdevelops.spring.core.aop.AopReasolver;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 接口日志保存
 * @author tn
 * @date  2020/6/1 21:04
 */

@SuppressWarnings("AlibabaLowerCamelCaseVariableNaming")
@Aspect
@Component
@Slf4j
public class ApiLogAspectSave {


    @Autowired
    private ApiLogSave apiLogSave;

    /**
     * appkey 异常时用
     */
    String appKeyError = "";


    /**
     * 定义切点 @Pointcut
     * 在注解的位置切入代码
     */
    @Pointcut("@annotation(cn.jdevelops.apilog.annotation.ApiLog)")
    public void apiLog() {
    }

    /**
     * 返回通知
     */
    @AfterReturning(value="apiLog()",returning="rvt")
    public void saveSysLog(JoinPoint joinPoint, Object rvt) {
        //保存日志
        ApiMonitoring apiLog = new ApiMonitoring();

        /*接口名*/
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        String requestUri = (request).getRequestURI();
        apiLog.setApiName(requestUri);

        /* outParams and  status  */
        if (ObjectUtils.allNotNull(rvt)) {
            try {
                if (rvt instanceof String || rvt instanceof Integer) {
                    apiLog.setStatus("true");
                } else if (rvt instanceof List) {
                    apiLog.setStatus("true");
                } else {
                    Map<String, Object> beanToMap = beanToMap(rvt);
                    apiLog.setStatus(beanToMap.get("success") + "");
                }
                apiLog.setOutParams(JSONObject.toJSONString(rvt));

            } catch (Exception e) {
                apiLog.setStatus("false");
                apiLog.setOutParams("");
            }
        }

        //从切面织入点处通过反射机制获取织入点处的方法
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        //获取切入点所在的方法
        Method method = signature.getMethod();
        /*key*/
        ApiLog myLog = method.getAnnotation(ApiLog.class);
        if (myLog != null) {
            Object apiKey = AopReasolver.newInstance().resolver(joinPoint, myLog.apiKey());
            appKeyError = ObjectUtils.allNotNull(rvt) ? apiKey + "" : "";
            apiLog.setApiKey(ObjectUtils.allNotNull(rvt) ? apiKey + "" : "");
        }

        /* callTime 调用时间  */
        apiLog.setCallTime(DateTime.now().toString(TimeFormatEnum.DEFAULT_FORMAT_DATETIME.getFormat()));
        /* callTime 调用时间  */


        /*inParams    输入 */
        //请求的参数
        Object[] args = joinPoint.getArgs();
        //将参数所在的数组转换成json
        try {
            String params = JSON.toJSONString(args);
            apiLog.setInParams(params.contains("null") ? params.replaceAll("null", "") : params);
        }catch (Exception e){
            apiLog.setInParams(null);
        }
        /*inParams    输入 */
        apiLog.setPoxyIp(IpUtil.getPoxyIp(request));
        apiLogSave.saveLog(apiLog);
    }
    /**
     * 异常通知
     */
    @AfterThrowing("apiLog()")
    public void doAfterThrowing(){

    }





    /**
     * 实体转Map
     * @param obj 实体
     * @return  Map
     */
    @SuppressWarnings("unchecked")
    private   Map<String, Object> beanToMap(Object obj) {
        Map<String, Object> params = new HashMap<>(15);
        try {
            PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
            PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors(obj);
            for (int i = 0; i < descriptors.length; i++) {
                String name = descriptors[i].getName();
                if (!"class".equals(name)) {
                    params.put(name, propertyUtilsBean.getNestedProperty(obj, name));
                }
            }
            if(obj!=null&&params.containsKey(StringEnum.EMPTY_STRING.getStr()) ){
                params = (Map<String, Object>) obj;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

}
