/*
 * Decompiled with CFR 0.152.
 */
package cn.jaychang.rocketmq.strategy;

import cn.jaychang.rocketmq.core.ConsumeStatusEnum;
import cn.jaychang.rocketmq.core.DedupConfig;
import cn.jaychang.rocketmq.persist.DedupElement;
import cn.jaychang.rocketmq.persist.IPersist;
import cn.jaychang.rocketmq.strategy.ConsumeStrategy;
import java.util.Map;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DedupConsumeStrategy
implements ConsumeStrategy {
    private static final Logger log = LoggerFactory.getLogger(DedupConsumeStrategy.class);
    private final DedupConfig dedupConfig;
    private final BiFunction<Object, Map<String, Object>, String> dedupMessageKeyFunction;

    @Override
    public <T> boolean invoke(BiFunction<T, Map<String, Object>, Boolean> consumeCallback, T message, Map<String, Object> extMap) {
        IPersist persist = this.dedupConfig.getPersist();
        String topic = (String)extMap.get("TOPIC");
        String tags = (String)extMap.getOrDefault("TAGS", "");
        String consumerGroup = (String)extMap.get("CONSUMER_GROUP");
        DedupElement dedupElement = new DedupElement(this.dedupConfig.getApplicationName(), topic, tags, consumerGroup, this.dedupMessageKeyFunction.apply(message, extMap));
        Boolean shouldConsume = true;
        if (dedupElement.getMsgUniqKey() != null) {
            shouldConsume = persist.setConsumingIfNX(dedupElement, this.dedupConfig.getDedupProcessingExpireMilliSeconds());
        }
        if (shouldConsume != null && shouldConsume.booleanValue()) {
            return this.doHandleMsgAndUpdateStatus(consumeCallback, message, extMap, dedupElement);
        }
        Integer val = persist.getConsumeStatus(dedupElement);
        ConsumeStatusEnum consumeStatusEnum = ConsumeStatusEnum.codeOf(val);
        String msgId = (String)extMap.get("MSG_ID");
        if (ConsumeStatusEnum.CONSUMING.equals((Object)consumeStatusEnum)) {
            log.warn("the same message is considered consuming, try consume later dedupKey : {}, {}, {}", new Object[]{persist.toPrintInfo(dedupElement), msgId, persist.getClass().getSimpleName()});
            return false;
        }
        if (ConsumeStatusEnum.CONSUMED.equals((Object)consumeStatusEnum)) {
            log.warn("message has been consumed before! dedupKey : {}, msgId : {} , so just ack. {}", new Object[]{persist.toPrintInfo(dedupElement), msgId, persist.getClass().getSimpleName()});
            return true;
        }
        log.warn("[NOTIFYME]unknown consume result {}, ignore dedup, continue consuming,  dedupKey : {}, {}, {} ", new Object[]{val, persist.toPrintInfo(dedupElement), msgId, persist.getClass().getSimpleName()});
        return this.doHandleMsgAndUpdateStatus(consumeCallback, message, extMap, dedupElement);
    }

    private <T> boolean doHandleMsgAndUpdateStatus(BiFunction<T, Map<String, Object>, Boolean> consumeCallback, T message, Map<String, Object> extMap, DedupElement dedupElement) {
        String msgId = (String)extMap.get("MSG_ID");
        if (dedupElement.getMsgUniqKey() == null) {
            log.warn("dedup key is null , consume msg but not update status{}", (Object)msgId);
            return consumeCallback.apply(message, extMap);
        }
        IPersist persist = this.dedupConfig.getPersist();
        boolean consumeRes = false;
        try {
            consumeRes = consumeCallback.apply(message, extMap);
        }
        catch (Throwable e) {
            try {
                persist.delete(dedupElement);
            }
            catch (Exception ex) {
                log.error("error when delete dedup record {}", (Object)dedupElement, (Object)ex);
            }
            log.error(String.format("consume %s failed", msgId), e);
            throw e;
        }
        try {
            if (consumeRes) {
                log.debug("set consume res as CONSUME_STATUS_CONSUMED , {}", (Object)dedupElement);
                persist.markConsumed(dedupElement, this.dedupConfig.getDedupRecordReserveMinutes());
            } else {
                log.info("consume Res is false, try deleting dedup record {} , {}", (Object)dedupElement, (Object)persist);
                persist.delete(dedupElement);
            }
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39\u53bb\u91cd\u6536\u5c3e\u5de5\u4f5c\u5f02\u5e38 {}\uff0c\u5ffd\u7565\u5f02\u5e38", (Object)msgId, (Object)e);
        }
        return consumeRes;
    }

    public DedupConsumeStrategy(DedupConfig dedupConfig, BiFunction<Object, Map<String, Object>, String> dedupMessageKeyFunction) {
        this.dedupConfig = dedupConfig;
        this.dedupMessageKeyFunction = dedupMessageKeyFunction;
    }
}

