/*
 * Decompiled with CFR 0.152.
 */
package cn.jaychang.rocketmq.persist;

import cn.jaychang.rocketmq.core.ConsumeStatusEnum;
import cn.jaychang.rocketmq.persist.DedupElement;
import cn.jaychang.rocketmq.persist.IPersist;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;

public class RedisPersist
implements IPersist {
    private final StringRedisTemplate redisTemplate;
    private static final String COLON = ":";

    public RedisPersist(StringRedisTemplate redisTemplate) {
        if (redisTemplate == null) {
            throw new NullPointerException("redis template is null");
        }
        this.redisTemplate = redisTemplate;
    }

    @Override
    public boolean setConsumingIfNX(DedupElement dedupElement, long dedupProcessingExpireMilliSeconds) {
        String dedupKey = this.buildDedupMessageRedisKey(dedupElement);
        Boolean execute = (Boolean)this.redisTemplate.execute(redisConnection -> redisConnection.set(dedupKey.getBytes(), String.valueOf(ConsumeStatusEnum.CONSUMED.getCode()).getBytes(), Expiration.milliseconds((long)dedupProcessingExpireMilliSeconds), RedisStringCommands.SetOption.SET_IF_ABSENT));
        if (execute == null) {
            return false;
        }
        return execute;
    }

    @Override
    public void delete(DedupElement dedupElement) {
        String dedupKey = this.buildDedupMessageRedisKey(dedupElement);
        this.redisTemplate.delete((Object)dedupKey);
    }

    @Override
    public void markConsumed(DedupElement dedupElement, long dedupRecordReserveMinutes) {
        String dedupKey = this.buildDedupMessageRedisKey(dedupElement);
        this.redisTemplate.opsForValue().set((Object)dedupKey, (Object)String.valueOf(ConsumeStatusEnum.CONSUMING.getCode()), dedupRecordReserveMinutes, TimeUnit.MINUTES);
    }

    @Override
    public Integer getConsumeStatus(DedupElement dedupElement) {
        String dedupKey = this.buildDedupMessageRedisKey(dedupElement);
        return Integer.valueOf((String)this.redisTemplate.opsForValue().get((Object)dedupKey));
    }

    @Override
    public String toPrintInfo(DedupElement dedupElement) {
        return this.buildDedupMessageRedisKey(dedupElement);
    }

    private String buildDedupMessageRedisKey(DedupElement dedupElement) {
        if (StringUtils.isEmpty((CharSequence)dedupElement.getMsgUniqKey())) {
            return null;
        }
        String tag = StringUtils.isNotBlank((CharSequence)dedupElement.getTag()) ? COLON + dedupElement.getTag() : "";
        String prefix = "MQ:CONSUME_DEDUP:" + dedupElement.getApplication() + COLON + dedupElement.getTopic() + tag + COLON + dedupElement.getConsumerGroup();
        return prefix + COLON + dedupElement.getMsgUniqKey();
    }
}

