/*
 * Decompiled with CFR 0.152.
 */
package cn.jaychang.rocketmq.persist;

import cn.jaychang.rocketmq.core.ConsumeStatusEnum;
import cn.jaychang.rocketmq.persist.DedupElement;
import cn.jaychang.rocketmq.persist.IPersist;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;

public class JDBCPersist
implements IPersist {
    private static final Logger log = LoggerFactory.getLogger(JDBCPersist.class);
    private final JdbcTemplate jdbcTemplate;
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public JDBCPersist(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public boolean setConsumingIfNX(DedupElement dedupElement, long dedupProcessingExpireMilliSeconds) {
        long expireTime = System.currentTimeMillis() + dedupProcessingExpireMilliSeconds;
        try {
            String dateTimeStr = DateFormatUtils.format((Date)new Date(), (String)DATE_TIME_FORMAT);
            int n = this.jdbcTemplate.update("INSERT INTO t_rocketmq_dedup(create_time,update_time,application_name, topic, tag, consumer_group, msg_uniq_key, consume_status, expire_time) values (?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{dateTimeStr, dateTimeStr, dedupElement.getApplication(), dedupElement.getTopic(), dedupElement.getTag(), dedupElement.getConsumerGroup(), dedupElement.getMsgUniqKey(), ConsumeStatusEnum.CONSUMING.getCode(), expireTime});
        }
        catch (DuplicateKeyException e) {
            log.warn("found consuming/consumed record, set setConsumingIfNX fail {}", (Object)dedupElement);
            int i = this.delete(dedupElement, true);
            if (i > 0) {
                log.info("delete {} expire records, now retry setConsumingIfNX again", (Object)i);
                return this.setConsumingIfNX(dedupElement, dedupProcessingExpireMilliSeconds);
            }
            return false;
        }
        catch (Exception e) {
            log.error("unknown error when jdbc insert, will consider success", (Throwable)e);
            return true;
        }
        return true;
    }

    private int delete(DedupElement dedupElement, boolean onlyExpire) {
        if (onlyExpire) {
            return this.jdbcTemplate.update("DELETE FROM t_rocketmq_dedup  WHERE application_name = ? AND topic =? AND tag = ? AND consumer_group = ? AND msg_uniq_key = ? AND expire_time < ?", new Object[]{dedupElement.getApplication(), dedupElement.getTopic(), dedupElement.getTag(), dedupElement.getConsumerGroup(), dedupElement.getMsgUniqKey(), System.currentTimeMillis()});
        }
        return this.jdbcTemplate.update("DELETE FROM t_rocketmq_dedup  WHERE application_name = ? AND topic =? AND tag = ? AND consumer_group = ? AND msg_uniq_key = ?", new Object[]{dedupElement.getApplication(), dedupElement.getTopic(), dedupElement.getTag(), dedupElement.getConsumerGroup(), dedupElement.getMsgUniqKey()});
    }

    @Override
    public void delete(DedupElement dedupElement) {
        this.delete(dedupElement, false);
    }

    @Override
    public void markConsumed(DedupElement dedupElement, long dedupRecordReserveMinutes) {
        long expireTime = System.currentTimeMillis() + dedupRecordReserveMinutes * 60L * 1000L;
        String dateTimeStr = DateFormatUtils.format((Date)new Date(), (String)DATE_TIME_FORMAT);
        int i = this.jdbcTemplate.update("UPDATE t_rocketmq_dedup SET update_time = ? ,consume_status = ? , expire_time  = ? WHERE application_name = ? AND topic = ? AND tag = ? AND consumer_group = ? AND msg_uniq_key = ? ", new Object[]{dateTimeStr, ConsumeStatusEnum.CONSUMED.getCode(), expireTime, dedupElement.getApplication(), dedupElement.getTopic(), dedupElement.getTag(), dedupElement.getConsumerGroup(), dedupElement.getMsgUniqKey()});
    }

    @Override
    public Integer getConsumeStatus(DedupElement dedupElement) {
        Integer consumeStatus = (Integer)this.jdbcTemplate.queryForObject("SELECT consume_status FROM t_rocketmq_dedup WHERE application_name = ? AND topic = ? AND tag = ?  AND consumer_group = ? AND msg_uniq_key  = ? and expire_time > ?", new Object[]{dedupElement.getApplication(), dedupElement.getTopic(), dedupElement.getTag(), dedupElement.getConsumerGroup(), dedupElement.getMsgUniqKey(), System.currentTimeMillis()}, Integer.class);
        return consumeStatus;
    }

    @Override
    public void clearExpiredRecord() {
        int update = this.jdbcTemplate.update("DELETE FROM t_rocketmq_dedup WHERE expire_time < ? AND consume_status = ?", new Object[]{System.currentTimeMillis(), ConsumeStatusEnum.CONSUMED.getCode()});
        log.debug("{} record has been removed.", (Object)update);
    }
}

