/*
 * Decompiled with CFR 0.152.
 */
package cn.jaychang.rocketmq.core;

import cn.jaychang.rocketmq.persist.IPersist;
import cn.jaychang.rocketmq.persist.JDBCPersist;
import cn.jaychang.rocketmq.persist.RedisPersist;
import java.util.function.Function;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;

public class DedupConfig {
    public static final int DEDUP_STRATEGY_DISABLE = 0;
    public static final int DEDUP_STRATEGY_CONSUME_LATER = 1;
    private String applicationName;
    private IPersist persist;
    private int dedupStrategy = 0;
    private long dedupProcessingExpireMilliSeconds;
    private long dedupRecordReserveMinutes;
    public static Function<MessageExt, String> defaultDedupMessageKeyFunction = messageExt -> {
        String uniqID = MessageClientIDSetter.getUniqID((Message)messageExt);
        if (uniqID == null) {
            return messageExt.getMsgId();
        }
        return uniqID;
    };

    public DedupConfig() {
    }

    private DedupConfig(String applicationName, int dedupStrategy, StringRedisTemplate redisTemplate) {
        if (redisTemplate != null) {
            this.persist = new RedisPersist(redisTemplate);
        }
        this.dedupStrategy = dedupStrategy;
        this.applicationName = applicationName;
    }

    private DedupConfig(String applicationName, int dedupStrategy, JdbcTemplate jdbcTemplate) {
        if (jdbcTemplate != null) {
            this.persist = new JDBCPersist(jdbcTemplate);
        }
        this.dedupStrategy = dedupStrategy;
        this.applicationName = applicationName;
    }

    private DedupConfig(String applicationName) {
        this.dedupStrategy = 0;
        this.applicationName = applicationName;
    }

    public static DedupConfig enableDedupConsumeConfig(String applicationName, StringRedisTemplate redisTemplate) {
        return new DedupConfig(applicationName, 1, redisTemplate);
    }

    public static DedupConfig enableDedupConsumeConfig(String applicationName, JdbcTemplate jdbcTemplate) {
        return new DedupConfig(applicationName, 1, jdbcTemplate);
    }

    public static DedupConfig disableDupConsumeConfig(String applicationName) {
        return new DedupConfig(applicationName);
    }

    public void setDedupProcessingExpireMilliSeconds(long dedupProcessingExpireMilliSeconds) {
        this.dedupProcessingExpireMilliSeconds = dedupProcessingExpireMilliSeconds;
    }

    public void setDedupRecordReserveMinutes(long dedupRecordReserveMinutes) {
        this.dedupRecordReserveMinutes = dedupRecordReserveMinutes;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public IPersist getPersist() {
        return this.persist;
    }

    public int getDedupStrategy() {
        return this.dedupStrategy;
    }

    public long getDedupProcessingExpireMilliSeconds() {
        return this.dedupProcessingExpireMilliSeconds;
    }

    public long getDedupRecordReserveMinutes() {
        return this.dedupRecordReserveMinutes;
    }

    public DedupConfig setApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public DedupConfig setPersist(IPersist persist) {
        this.persist = persist;
        return this;
    }

    public DedupConfig setDedupStrategy(int dedupStrategy) {
        this.dedupStrategy = dedupStrategy;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DedupConfig)) {
            return false;
        }
        DedupConfig other = (DedupConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDedupStrategy() != other.getDedupStrategy()) {
            return false;
        }
        if (this.getDedupProcessingExpireMilliSeconds() != other.getDedupProcessingExpireMilliSeconds()) {
            return false;
        }
        if (this.getDedupRecordReserveMinutes() != other.getDedupRecordReserveMinutes()) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        IPersist this$persist = this.getPersist();
        IPersist other$persist = other.getPersist();
        return !(this$persist == null ? other$persist != null : !this$persist.equals(other$persist));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DedupConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDedupStrategy();
        long $dedupProcessingExpireMilliSeconds = this.getDedupProcessingExpireMilliSeconds();
        result = result * 59 + (int)($dedupProcessingExpireMilliSeconds >>> 32 ^ $dedupProcessingExpireMilliSeconds);
        long $dedupRecordReserveMinutes = this.getDedupRecordReserveMinutes();
        result = result * 59 + (int)($dedupRecordReserveMinutes >>> 32 ^ $dedupRecordReserveMinutes);
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        IPersist $persist = this.getPersist();
        result = result * 59 + ($persist == null ? 43 : $persist.hashCode());
        return result;
    }

    public String toString() {
        return "DedupConfig(applicationName=" + this.getApplicationName() + ", persist=" + this.getPersist() + ", dedupStrategy=" + this.getDedupStrategy() + ", dedupProcessingExpireMilliSeconds=" + this.getDedupProcessingExpireMilliSeconds() + ", dedupRecordReserveMinutes=" + this.getDedupRecordReserveMinutes() + ")";
    }
}

