/*
 * Decompiled with CFR 0.152.
 */
package cn.jaychang.rocketmq.core;

import cn.jaychang.rocketmq.base.AbstractMQPushConsumer;
import cn.jaychang.rocketmq.core.DedupConfig;
import cn.jaychang.rocketmq.strategy.ConsumeStrategy;
import cn.jaychang.rocketmq.strategy.DedupConsumeStrategy;
import cn.jaychang.rocketmq.strategy.NormalConsumeStrategy;
import java.util.Map;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDedupMQConsumer<T>
extends AbstractMQPushConsumer<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDedupMQConsumer.class);
    protected DedupConfig dedupConfig = DedupConfig.disableDupConsumeConfig("NOT-SET-CONSUMER-GROUP");

    public AbstractDedupMQConsumer() {
        log.info("Construct AbstractDedupMQConsumer with default {}", (Object)this.dedupConfig);
    }

    public AbstractDedupMQConsumer(DedupConfig dedupConfig) {
        this.dedupConfig = dedupConfig;
        log.info("Construct AbstractDedupMQConsumer with dedupConfig {}", (Object)dedupConfig);
    }

    public boolean process(T message, Map<String, Object> extMap) {
        ConsumeStrategy strategy = new NormalConsumeStrategy();
        BiFunction<Object, Map<String, Object>, String> dedupKeyFunction = this::dedupMessageKey;
        if (this.dedupConfig.getDedupStrategy() == 1) {
            strategy = new DedupConsumeStrategy(this.dedupConfig, dedupKeyFunction);
        }
        BiFunction<Object, Map, Boolean> doProcessFun = this::doProcess;
        return strategy.invoke(doProcessFun, message, extMap);
    }

    protected abstract boolean doProcess(T var1, Map<String, Object> var2);

    protected String dedupMessageKey(T message, Map<String, Object> extMap) {
        String uniqueID = (String)extMap.get("UNIQ_KEY");
        if (uniqueID == null) {
            return (String)extMap.get("MSG_ID");
        }
        return uniqueID;
    }

    public void setDedupConfig(DedupConfig dedupConfig) {
        this.dedupConfig = dedupConfig;
    }
}

