/*
 * Decompiled with CFR 0.152.
 */
package cn.jaychang.rocketmq.config;

import cn.jaychang.rocketmq.annotation.MQConsumer;
import cn.jaychang.rocketmq.config.DedupProperties;
import cn.jaychang.rocketmq.config.MQConsumerAutoConfiguration;
import cn.jaychang.rocketmq.core.AbstractDedupMQConsumer;
import cn.jaychang.rocketmq.core.DedupConfig;
import cn.jaychang.rocketmq.core.PersistTypeEnum;
import cn.jaychang.rocketmq.persist.JDBCPersist;
import cn.jaychang.rocketmq.persist.RedisPersist;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableConfigurationProperties(value={DedupProperties.class})
@AutoConfigureAfter(value={MQConsumerAutoConfiguration.class})
@ConditionalOnClass(value={DedupConfig.class})
public class MQConsumeDedupAutoConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MQConsumeDedupAutoConfiguration.class);
    @Autowired
    private DedupProperties dedupProperties;
    private ApplicationContext applicationContext;
    private ScheduledExecutorService scheduledExecutorService;

    @Bean
    @ConditionalOnMissingBean
    public DedupConfig dedupConfig() {
        log.debug("\u6d88\u606f\u6d88\u8d39\u9632\u91cd\u914d\u7f6e");
        DedupConfig dedupConfig = new DedupConfig();
        dedupConfig.setApplicationName(this.dedupProperties.getApplicationName());
        dedupConfig.setDedupProcessingExpireMilliSeconds(this.dedupProperties.getDedupProcessingExpireMilliSeconds());
        dedupConfig.setDedupStrategy(1);
        dedupConfig.setDedupRecordReserveMinutes(this.dedupProperties.getDedupRecordReserveMinutes());
        PersistTypeEnum persistType = this.dedupProperties.getPersistType();
        if (PersistTypeEnum.DB.equals((Object)persistType)) {
            JdbcTemplate jdbcTemplate = (JdbcTemplate)this.applicationContext.getBean(JdbcTemplate.class);
            if (Objects.isNull(jdbcTemplate)) {
                throw new RuntimeException("Can not found JdbcTemplate bean in spring context");
            }
            JDBCPersist jdbcPersist = new JDBCPersist(jdbcTemplate);
            dedupConfig.setPersist(jdbcPersist);
        } else if (PersistTypeEnum.REDIS.equals((Object)persistType)) {
            StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
            if (Objects.isNull(stringRedisTemplate)) {
                throw new RuntimeException("Can not found StringRedisTemplate bean in spring context");
            }
            RedisPersist redisPersist = new RedisPersist(stringRedisTemplate);
            dedupConfig.setPersist(redisPersist);
        } else {
            dedupConfig.setDedupStrategy(0);
        }
        return dedupConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() throws Exception {
        Map beans = this.applicationContext.getBeansWithAnnotation(MQConsumer.class);
        if (CollectionUtils.isEmpty((Map)beans)) {
            return;
        }
        DedupConfig dedupConfig = this.dedupConfig();
        for (Map.Entry entry : beans.entrySet()) {
            Object bean = entry.getValue();
            if (!AbstractDedupMQConsumer.class.isAssignableFrom(bean.getClass())) continue;
            AbstractDedupMQConsumer dedupMQConsumer = (AbstractDedupMQConsumer)((Object)bean);
            dedupMQConsumer.setDedupConfig(dedupConfig);
        }
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().daemon(true).namingPattern("ClearExpiredRocketmqDedupThread-%d").build());
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> dedupConfig.getPersist().clearExpiredRecord(), 24L, 24L, TimeUnit.HOURS);
    }
}

