/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.util;

import cn.javainterview.core.io.FastByteArrayOutputStream;
import cn.javainterview.core.io.IORuntimeException;
import cn.javainterview.core.io.IoUtil;
import cn.javainterview.core.io.ValidateObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;

public class SerializeUtil {
    public static <T> T clone(T obj) {
        if (!(obj instanceof Serializable)) {
            return null;
        }
        return SerializeUtil.deserialize(SerializeUtil.serialize(obj), new Class[0]);
    }

    public static <T> byte[] serialize(T obj) {
        if (!(obj instanceof Serializable)) {
            return null;
        }
        FastByteArrayOutputStream byteOut = new FastByteArrayOutputStream();
        IoUtil.writeObjects(byteOut, false, (Serializable)obj);
        return byteOut.toByteArray();
    }

    public static <T> T deserialize(byte[] bytes, Class<?> ... acceptClasses) {
        try {
            return IoUtil.readObj(new ValidateObjectInputStream(new ByteArrayInputStream(bytes), acceptClasses));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

