/*
 * Decompiled with CFR 0.152.
 */
package cn.javainterview.core.text.csv;

import cn.javainterview.core.io.FileUtil;
import cn.javainterview.core.io.IORuntimeException;
import cn.javainterview.core.io.IoUtil;
import cn.javainterview.core.text.csv.CsvBaseReader;
import cn.javainterview.core.text.csv.CsvData;
import cn.javainterview.core.text.csv.CsvReadConfig;
import cn.javainterview.core.text.csv.CsvRow;
import cn.javainterview.core.text.csv.CsvRowHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CsvReader
extends CsvBaseReader
implements Iterable<CsvRow>,
Closeable {
    private static final long serialVersionUID = 1L;
    private final Reader reader;

    public CsvReader() {
        this(null);
    }

    public CsvReader(CsvReadConfig config) {
        this((Reader)null, config);
    }

    public CsvReader(File file, CsvReadConfig config) {
        this(file, DEFAULT_CHARSET, config);
    }

    public CsvReader(Path path, CsvReadConfig config) {
        this(path, DEFAULT_CHARSET, config);
    }

    public CsvReader(File file, Charset charset, CsvReadConfig config) {
        this(FileUtil.getReader(file, charset), config);
    }

    public CsvReader(Path path, Charset charset, CsvReadConfig config) {
        this(FileUtil.getReader(path, charset), config);
    }

    public CsvReader(Reader reader, CsvReadConfig config) {
        super(config);
        this.reader = reader;
    }

    public CsvData read() throws IORuntimeException {
        return this.read(this.reader, false);
    }

    public void read(CsvRowHandler rowHandler) throws IORuntimeException {
        this.read(this.reader, false, rowHandler);
    }

    public Stream<CsvRow> stream() {
        return (Stream)StreamSupport.stream(this.spliterator(), false).onClose(() -> {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        });
    }

    @Override
    public Iterator<CsvRow> iterator() {
        return this.parse(this.reader);
    }

    @Override
    public void close() throws IOException {
        IoUtil.close(this.reader);
    }
}

